import React, { useEffect } from 'react';
import { useSearchParams } from 'react-router-dom';

const RedirectPage = () => {
  const [searchParams] = useSearchParams();
  const target = searchParams.get('t') || '/';

  useEffect(() => {
    // Force a full reload to update contexts, etc.
    window.location.reload(); // This forces a full reload
    // Then, after reload, redirect to the target.
    window.location.href = target;
  }, [target]);

  return <div>Redirecting...</div>;
};

export default RedirectPage;
