import axios from 'axios';
import React, { useState } from 'react';

const InviteUserModal = ({ onClose }) => {
    const [emailList, setEmailList] = useState('');
    const [isSuccess, setSuccess] = useState(false);
    const [role, setRole] = useState('2'); // Ensure this is a string as it matches the select option values
    const [successMessage, setSuccessMessage] = useState('');
    const [errorMessage, setErrorMessage] = useState('');
    const accountId = localStorage.getItem('account_id');
    const [isSubmitting, setIsSubmitting] = useState(false);
    
    const handleEmailListChange = (event) => setEmailList(event.target.value);
    const handleRoleChange = (event) => setRole(event.target.value);

    const handleSubmit = (event) => {
        event.preventDefault();
        if (isSubmitting) {
            //console.log('Submission is already in progress...');
            return;
        }
        
        setIsSubmitting(true); // Immediately disable the submit button

        // Simulate an API call
        axios.post('/users/emailverification/', {
            emails: emailList,
            action: 'invite',
            account_id: accountId,
            role: role
        }).then(response => {
            if (response.data && response.status === 200) {
                setSuccess(true);
                setSuccessMessage('Invitations sent successfully!');
                setEmailList('');
            } else {
                throw new Error('Failed to send invitations');
            }
        }).catch(error => {
            //console.error("Error inviting users:", error);
            setErrorMessage('Failed to send invitations. Please try again.');
        }).finally(() => {
            //console.log('Re-enabling submission...');
            setIsSubmitting(false); // Re-enable the submit button
        });
    };

    return (
        <div className="modal-overlay">
            <div className="modal-content">
                <h2>Invite Your Teams</h2>
                <div className='closeontoprightflow'>
                    <a href="#" onClick={onClose}><span className="material-symbols-outlined">close</span></a>
                </div>

                {isSuccess ? (
                    <>
                        <p style={{ color: 'green' }}>{successMessage}</p>
                        <button onClick={onClose}>Close</button>
                    </>
                ) : (
                    <>
                        {errorMessage && <p style={{ color: 'red' }}>{errorMessage}</p>}
                        <form onSubmit={handleSubmit}>
                            <label htmlFor="emailList">Email Addresses</label>
                            <input 
                                type="text" 
                                id="emailList" 
                                value={emailList}
                                onChange={handleEmailListChange}
                                placeholder="Enter emails separated by comma or space"
                                disabled={isSubmitting}
                            />
                            <label>Roles</label>
                            <select 
                                id="roles" 
                                value={role}
                                onChange={handleRoleChange}
                                disabled={isSubmitting}
                            >
                                <option value="2">Admin - Full Access</option>
                                <option value="3">Moderators - Can Create / Modify AI Agents</option>
                                <option value="4">Users - Can only Interact with AI Agents</option>
                            </select>
                            <br/><br/>
                            <button type="submit" disabled={isSubmitting}>
                            {isSubmitting ? "Inviting is in progress... You don't need to wait!" : "Send Invites"}
                            </button>
                        </form>
                    </>
                )}
            </div>
        </div>
    );
};

export default InviteUserModal;
