import React, { useEffect, useState } from 'react';
import axios from 'axios';

function InteractionModal({ interactionId, onClose }) {
  const [interaction, setInteraction] = useState(null);

  useEffect(() => {
    async function fetchInteraction() {
      try {
        const response = await axios.get(`/interactions/view/${interactionId}`);
        setInteraction(response.data);
      } catch (error) {
        console.error("Failed to fetch interaction:", error);
      }
    }

    if (interactionId) fetchInteraction();
  }, [interactionId]);

  if (!interaction) return null;

  // Helper function to convert the timestamp to a readable format
  function formatDate(timestamp) {
    const dateObj = new Date(timestamp);
    return dateObj.toLocaleString(); // This will give you a readable string format
  }

  return (
    <div className="modal-overlay">
      <div className="modal-content">
        <h2>{interaction.chat_title}
        <a href='#' onClick={onClose}><span class="material-symbols-outlined">close</span></a>
      </h2>
        
        <div className="chat-section">
          {interaction.chats.map((chat, index) => (
            <div key={index} className="chat-message">
              <div className={`chat-sender ${chat.sender === 'user' ? 'user' : 'other'}`}>
                {chat.sender}
              </div>
              <div className="chat-text">
                {chat.message}
              </div>
              <div className="chat-timestamp">
                {formatDate(chat.timestamp)}
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
}

export default InteractionModal;
