import React from 'react';

// Industry options for the select dropdown
const industries = [
  // "Technology",
  // "IT Services",
  // "Finance",
  // "Healthcare",
  // "Education",
  // "Automotive",
  // "Manufacturing",
  // "Retail",
  // "Transportation",
  // "Real Estate",
  // "Hospitality",
  // "Energy",
  // "Agriculture",
  // "Media and Entertainment",
  // "Consulting",
  // "Telecommunications",
  // "Legal",
  // "Non-Profit",
  // "Government",
  // "E-commerce",
  // "Construction",
  // "Biotechnology",
  // "Environmental Services",
  // "Food & Beverages",
  // "Arts & Crafts",
  // "Sports & Recreation",
  // "Others"
  "Transportation & Mobility",
  "Logistics & Supply Chain",
  "Healthcare & Medical Services",
  "Education & Institutions",
  "Government & Public Sector",
  "Telecommunications & Broadband",
  "Oil, Gas & Energy",
  "Construction & Infrastructure",
  "Home & Facility Services",
  "Field & On-Demand Services",
  "Retail & Hyperlocal Delivery",
  "Food & Beverage",
  "Courier & Express Delivery",
  "Waste Management & Recycling",
  "Security & Emergency Response",
  "Tourism & Hospitality",
  "Event Management & Entertainment",
  "Rental & Leasing Services",
  "Manufacturing & Industrial Operations",
  "Automotive & Maintenance Services",
  "Professional & Workforce Services",
  "Agriculture & Farming",
  "Real Estate & Property Management",
  "Banking & Financial Services",
  "Utilities & Public Works",
  "Others"
];

const IndustrySelect = ({ selectedIndustry, onChange }) => {
  return (
    <div className="industry-select-container">
      <label htmlFor="industry-select">Your Industry</label>
      <select
        id="industry-select"
        value={selectedIndustry}
        onChange={onChange}
        required
      >
        <option value="" disabled>Select your industry</option>
        {industries.map(industry => (
          <option key={industry} value={industry}>{industry}</option>
        ))}
      </select>
    </div>
  );
};

export default IndustrySelect;
