import React, { useEffect, useState } from 'react';

function AppModal({ appId, onClose }) {
  const [app, setApp] = useState(null);
  const [content, setContent] = useState(null);
  const [stat, setStat] = useState(null);

  useEffect(() => {
    async function fetchApp() {
      try {
        //const response = await axios.get(`/apps/v/detail/${appId}/`);
        return;
        //setApp(response.data);
      } catch (error) {
        console.error("Failed to fetch app:", error);
      }
    }
      if (appId) {
        fetchApp();
      }
          
  }, [appId]);

  if (!app) return null;

  // Helper function to convert the timestamp to a readable format
  function formatDate(timestamp) {
    const dateObj = new Date(timestamp);
    return dateObj.toLocaleDateString("en-US", {
      year: 'numeric', month: 'long', day: 'numeric',
      hour: '2-digit', minute: '2-digit', second: '2-digit',
      hour12: true
    });
  }

  function ensureArray(item) {
    if (Array.isArray(item)) return item;
    if (item) return [item];
    return [];
  }
   
  return (
    <div className="modal-overlay">
      <div className="modal-content">
        <h2>{app.title} <a href="#" onClick={onClose}><span className="material-symbols-outlined">close</span></a></h2>


      </div>
    </div>
  );
}

export default AppModal;
