import React, { useState } from 'react';
import axios from 'axios';

function DeleteUserModal({ userId, accountId, onClose }) {
    const [isSuccess, setSuccess] = useState(false);
    const [successMessage, setSuccessMessage] = useState('');
    const [errorMessage, setErrorMessage] = useState('');
    const [isSubmitting, setIsSubmitting] = useState(false);
    const user_id = localStorage.getItem('user_id');

    const deleteUser = async () => {
        if(isSubmitting) return;
        if(user_id === userId){
            setErrorMessage('You cannot delete yourself.');
            return;
        }
        try {
            setIsSubmitting(true);
            const response = await axios.delete(`/users/d/${accountId}/${userId}/`);
            
            if (response.status === 200) {
                setSuccess(true);
                setSuccessMessage('Member has been successfully deleted.');
                setErrorMessage('');
                // You might want to add additional logic here, like refreshing the user list
            } else {
                setErrorMessage('Failed to delete the member. Please try again.');
            }
        } catch (error) {
            console.error("Error deleting the user:", error);
            setErrorMessage('Failed to delete the member. Please try again.');
        }
        setIsSubmitting(false);
    };

    return (
        <div className="modal-overlay">
            <div className="modal-content">
            <h2>Delete Member</h2>
            <div className='closeontoprightflow'>
            <a href="#" onClick={onClose} ><span className="material-symbols-outlined">close</span></a>
            </div>

                {isSuccess ? (
                    <>
                        <p style={{ color: 'green' }}>{successMessage}</p>
                    </>
                ) : (
                    <>
                        {errorMessage && <p style={{ color: 'red' }}>{errorMessage}</p>}
                        <p>Are you sure you want to delete this member?</p>
                        {user_id === userId ? (
                            <p style={{ color: 'red' }}>You cannot delete yourself.</p>
                        ) : (
                            <button onClick={deleteUser} disabled={isSubmitting}>Delete</button>
                        )}
                    </>
                )}
            </div>
        </div>
    );
}

export default DeleteUserModal;
