import React, { useState } from 'react';
import axios from 'axios';

function DeleteProjectFlowModal({ projectFlowId, projectId, onClose }) {
    const [isSuccess, setSuccess] = useState(false);
    const [successMessage, setSuccessMessage] = useState('');
    const [errorMessage, setErrorMessage] = useState('');
    const [isSubmitting, setIsSubmitting] = useState(false);

    const deleteFlow = async () => {
        if(isSubmitting) return;

        try {
            setIsSubmitting(true);
            const response = await axios.delete(`/flows/projectflow/${projectId}/${projectFlowId}/`);
            
            if (response.status === 200) {
                setSuccess(true);
                const data = response.data;
                const message = `Flow has been successfully removed from this Agent.`;
                setSuccessMessage(message);
                setErrorMessage('');
                // Additional logic such as refreshing the flow list can be added here
            } else {
                setErrorMessage('Failed to remove the integrated flow. Please try again.');
            }
        } catch (error) {
            setErrorMessage('Failed to remove the integrated flow. Please try again.');
        }
        setIsSubmitting(false);
    };

    return (
        <div className="modal-overlay">
            <div className="modal-content">
            <h2>Remove Integrated flow </h2>
            <div className='closeontoprightflow'>
            <a href="#" onClick={onClose} ><span className="material-symbols-outlined">close</span></a>
            </div>


            <p>Please be aware that removing the integration will result that this flow won't be active for this Agent.</p>

                {isSuccess ? (
                    <>
                        <p style={{ color: 'green' }}>{successMessage}</p>
                        <p><button onClick={onClose}>Close</button></p>
                    </>
                ) : (
                    <>
                        {errorMessage && <p style={{ color: 'red' }}>{errorMessage}</p>}
                        <p>Are you sure you want to remove this flow for this agent ?</p>
                        <center>
                        <button onClick={deleteFlow} disabled={isSubmitting}>Remove</button>
                        <br/><br/>
                        or <a href='#' onClick={onClose}>Cancel</a>
                        </center>
                    </>
                )}
            </div>
        </div>
    );
}

export default DeleteProjectFlowModal;
