import React, { useState } from 'react';
import axios from 'axios';

function DeleteFlowModal({ flowId, accountId, onClose }) {
    const [isSuccess, setSuccess] = useState(false);
    const [successMessage, setSuccessMessage] = useState('');
    const [errorMessage, setErrorMessage] = useState('');
    const [isSubmitting, setIsSubmitting] = useState(false);

    const deleteFlow = async () => {
        if(isSubmitting) return;
        try {
            setIsSubmitting(true);
            const response = await axios.delete(`/flows/d/${accountId}/${flowId}`);
            
            if (response.status === 200) {
                setSuccess(true);
                const data = response.data;
                const message = `Flow has been successfully deleted. 
                                 Deleted ${data.deleted_flows_count} flow(s) and 
                                 ${data.deleted_project_flows_count} agent flow integration(s).`;
                setSuccessMessage(message);
                setErrorMessage('');
                // Additional logic such as refreshing the flow list can be added here
            } else {
                setErrorMessage('Failed to delete the flow. Please try again.');
            }
        } catch (error) {
            setErrorMessage('Failed to delete the flow. Please try again.');
        }
        setIsSubmitting(false);
    };

    return (
        <div className="modal-overlay">
            <div className="modal-content">
            <h2>Delete Flow </h2>
            <div className='closeontoprightflow'>
            <a href="#" onClick={onClose} ><span className="material-symbols-outlined">close</span></a>
            </div>

            <p>Please be aware that deleting the flow will result in the permanent removal of all data associated. This flow will be removed from all AI Agents automatically.</p>

                {isSuccess ? (
                    <>
                        <p style={{ color: 'green' }}>{successMessage}</p>
                        <p><button onClick={onClose}>Close</button></p>
                    </>
                ) : (
                    <>
                        {errorMessage && <p style={{ color: 'red' }}>{errorMessage}</p>}
                        <p>Are you sure you want to delete this flow?</p>
                        <button onClick={deleteFlow} disabled={isSubmitting}>Delete</button>
                        <br/><br/>
                        If not interested, <a href='#' onClick={onClose}>Cancel.</a>
                    </>
                )}
            </div>
        </div>
    );
}

export default DeleteFlowModal;
