import React, { useState } from 'react';
import axios from 'axios';

function DeleteAppIntegrationModal({ accountId, appIntegrationId, integrationName, onClose }) {
    const [isSuccess, setSuccess] = useState(false);
    const [successMessage, setSuccessMessage] = useState('');
    const [errorMessage, setErrorMessage] = useState('');
    const [isSubmitting, setIsSubmitting] = useState(false);

    const deleteFlow = async () => {
        if(isSubmitting) return;
        try {
            setIsSubmitting(true);
            const response = await axios.delete(`/appflow/integrations/remove/${accountId}/${appIntegrationId}`);
            
            if (response.status === 200) {
                setSuccess(true);
                const data = response.data;
                const message = `App Integration has been successfully removed.`;
                setSuccessMessage(message);
                setErrorMessage('');
                // Additional logic such as refreshing the flow list can be added here
            } else {
                setErrorMessage('Failed to remove the App Integration. Please try again.');
            }
        } catch (error) {
            setErrorMessage('Failed to remove the App Integration. Please try again.');
        }
        setIsSubmitting(false);
    };

    return (
        <div className="modal-overlay">
            <div className="modal-content">
            <h2>Delete Integration</h2>
            <div className='closeontoprightflow'>
            <a href="#" onClick={onClose} ><span className="material-symbols-outlined">close</span></a>
            </div>

            <p>Please be aware that removing the integration all associated flows will be deleted.</p>

                {isSuccess ? (
                    <>
                        <p style={{ color: 'green' }}>{successMessage}</p>
                        <a href="#" onClick={onClose} className='closeontopright'><span className="material-symbols-outlined">cancel</span></a>
                    </>
                ) : (
                    <>
                        {errorMessage && <p style={{ color: 'red' }}>{errorMessage}</p>}
                        <p>Are you sure you want to remove this integration & all related flows ?</p>
                        <button onClick={deleteFlow} disabled={isSubmitting}>Remove</button>
                        <br/><br/>
                        If not interested, <a href='#' onClick={onClose}>Cancel</a>
                    </>
                )}
            </div>
        </div>
    );
}

export default DeleteAppIntegrationModal;
