import React, { useState } from 'react';
import axios from 'axios';

function DeleteAgentModal({ projectId, accountId, onClose, onSuccessfulDeletion }) {
    const [isSuccess, setSuccess] = useState(false);
    const [successMessage, setSuccessMessage] = useState('');
    const [errorMessage, setErrorMessage] = useState('');
    const [isSubmitting, setIsSubmitting] = useState(false);

    const deleteAgent = async () => {
        if(isSubmitting) return;
        try {
            setIsSubmitting(true);
            const response = await axios.delete(`/projects/d/${accountId}/${projectId}/`);
            
            if (response.status === 200) {
                setSuccess(true);
                setSuccessMessage('Agent has been successfully deleted.! ');
                setErrorMessage('');

                if (onSuccessfulDeletion) {
                    onSuccessfulDeletion();
                }
                
                // You might want to add additional logic here, like refreshing the user list
            } else {
                setErrorMessage('Failed to delete the Agent. Please try again.');
            }
        } catch (error) {
            console.error("Error deleting the Agent:", error);
            setErrorMessage('Failed to delete the Agent. Please try again.');
        }
        setIsSubmitting(false);
    };

    return (
        <div className="modal-overlay">
            <div className="modal-content">
            <h2>Delete AI Agent</h2>
            <div className='closeontoprightflow'>
            <a href="#" onClick={onClose} ><span className="material-symbols-outlined">close</span></a>
            </div>
            <p>Please be aware that deleting the agent will result in the permanent removal of all data associated with this AI Agent.</p>
                {isSuccess ? (
                    <>
                        <p style={{ color: 'green' }}>{successMessage}</p>
                        <p><button onClick={onClose}>Close</button></p>
                    </>
                ) : (
                    <>
                        {errorMessage && <p style={{ color: 'red' }}>{errorMessage}</p>}
                        <p>Are you sure you want to delete this Agent?</p>
                        <button onClick={deleteAgent} disabled={isSubmitting}>Delete</button>
                        <br/><br/>
                        <a href='#' onClick={onClose}>If you dont want to delete, please cancel!</a>
                    </>
                )}
            </div>
        </div>
    );
}

export default DeleteAgentModal;
