// src/components/common/Menu/index.js
import React from 'react';
import { Link, useLocation } from 'react-router-dom';

const Menu = () => {

  const location = useLocation();
  const userId = localStorage.getItem('user_id');
  const name = localStorage.getItem('name');
  const profileImageUrl = localStorage.getItem('picurl'); // Assuming you store the profile image URL

  const renderUserDetails = () => {
    return (
      <div className="profile-row">
        {profileImageUrl ? (
          <img src={profileImageUrl} alt="Profile" className="profile-image" />
        ) : (
          <span className="profile-placeholder-menu">
            {name.charAt(0).toUpperCase()}
          </span>
        )}
        <span className="user-name-menu"><Link to="/settings">{name}</Link></span>
      </div>
    );
  };
    const isMenuItemActive = (path) => {
      location.pathname.startsWith('/billing')
    return location.pathname.startsWith(path);
  };
//      <a href='/' className="logo-text"><span className="material-symbols-outlined">filter_vintage</span>thought</a>
  return (
    <aside className="menu">
      {/* Main Menu */}      
      <div className="main-menu">
      <Link to='/' className="logo-text"><img src='/logo.png' />Thought</Link>

        <Link to="/dash" className={`menu-item ${isMenuItemActive("/dash") ? "selected" : ""}`}>
          <span className="material-symbols-outlined">home</span>          
            Dashboard
          </Link>
        <Link to="/agents" className={`menu-item ${isMenuItemActive("/agents") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">dialogs</span>          
          Agents
        </Link>
        <Link to="/flows" className={`menu-item ${isMenuItemActive("/flows") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">spa</span>          
          Flows
        </Link>
        <Link to="/apps" className={`menu-item ${isMenuItemActive("/apps") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">grid_view</span>          
          Apps
        </Link>
        <Link to="/interactions" className={`menu-item ${isMenuItemActive("/interactions") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">sentiment_satisfied</span>          
          Interactions
        </Link>
        <Link to="/visitors" className={`menu-item ${isMenuItemActive("/visitors") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">account_circle</span>          
          Visitors
        </Link>
        {/* ... other main menu items */}
      </div>

      {/* Secondary Menu */}
      <div className="secondary-menu">
      <Link to="/billing" className={`menu-item ${isMenuItemActive("/billing") ? "selected" : ""}`}>        
      <span className="material-symbols-outlined">monetization_on</span> Billing
        </Link>
        <Link to="/members" className={`menu-item ${isMenuItemActive("/members") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">manage_accounts</span>Users
        </Link>
        <Link to="/settings" className={`menu-item ${isMenuItemActive("/settings") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">settings</span>Settings
        </Link>
        {/* ... other secondary menu items */}
        {renderUserDetails()}
      </div>
    </aside>
  );
};

export default Menu;
