// src/components/common/Menu/index.js
import React from 'react';
import { Link, useLocation } from 'react-router-dom';
import History  from '../../pages/Portal/History';

const Menu = () => {

  const location = useLocation();
  const userId = localStorage.getItem('user_id');
  const name = localStorage.getItem('name');
  const profileImageUrl = localStorage.getItem('picurl'); // Assuming you store the profile image URL

  const renderUserDetails = () => {
    return (
      <div className="profile-row">
        {profileImageUrl ? (
          <img src={profileImageUrl} alt="Profile" className="profile-image" />
        ) : (
          <span className="profile-placeholder-menu">
            {name.charAt(0).toUpperCase()}
          </span>
        )}
        <span className="user-name-menu"><Link to="/settings">{name}</Link></span>
      </div>
    );
  };
    const isMenuItemActive = (path) => {
      location.pathname.startsWith('/billing')
    return location.pathname.startsWith(path);
  };
//      <a href='/' className="logo-text"><span className="material-symbols-outlined">filter_vintage</span>thought</a>
  return (
    <aside className="menu">
      {/* Main Menu */}      
      <div className="main-menu">
      <Link to='#' className="logo-text"><img src='/logo_dark.png' /></Link>
        <Link to="/ai.workers" className={`menu-item ${isMenuItemActive("/dash") ? "selected" : ""}`}>
          <span className="material-symbols-outlined">dialogs</span>          
            Interact
        </Link>
        <Link to="/flows" className={`menu-item ${isMenuItemActive("/flows") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">description</span>          
          Documents
        </Link>
        <Link to="/interactions" className={`menu-item ${isMenuItemActive("/interactions") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">history</span>          
          History
        </Link>
        <History />
        {/* ... other main menu items */}
      </div>

      {/* Secondary Menu */}
      <div className="secondary-menu">
        <Link to="/settings" className={`menu-item ${isMenuItemActive("/settings") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">settings</span>Settings
        </Link>
        {renderUserDetails()}
        <Link to="/logout" className={`menu-item ${isMenuItemActive("/billing") ? "selected" : ""}`}>        
      <span className="material-symbols-outlined">logout</span> Logout
        </Link>
      </div>
    </aside>
  );
};

export default Menu;
