// src/components/common/Menu/index.js
import React, { useEffect } from 'react';
import { Link, useLocation } from 'react-router-dom';
import '../../themes/blue/Menu.css';

const SuperAdminMenu = () => {
  const location = useLocation();
  const userId = localStorage.getItem('user_id');
  const name = localStorage.getItem('name');
  const profileImageUrl = localStorage.getItem('picurl'); // Assuming you store the profile image URL

  const userRights = localStorage.getItem('role_rights') || [];

  const isMenuItemActive = (path) => {
    return location.pathname === path;
  };


  const renderUserDetails = () => {
    return (
      <div className="profile-row">
        {profileImageUrl ? (
          <img src={profileImageUrl} alt="Profile" className="profile-image" />
        ) : (
          <span className="profile-placeholder-menu">
            {name.charAt(0).toUpperCase()}
          </span>
        )}
        <span className="user-name-menu"><a href="/settings">{name}</a></span>
      </div>
    );
  };


  return (
    <aside className="menu">
      {/* Main Menu */}
      <div className="main-menu">
      <a href='/' className="logo-text"><img src='/logo_dark.png' /></a>
        <Link to="/saas/dash" className={`menu-item ${isMenuItemActive("/saas/dash") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">dashboard</span>          
          Dashboard
        </Link>
        <Link to="/saas/accounts" className={`menu-item ${isMenuItemActive("/saas/accounts") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">storefront</span>          
          Accounts
        </Link>
     <Link to="/saas/subscriptions" className={`menu-item ${isMenuItemActive("/saas/subscriptions") ? "selected" : ""}`}>
  <span className="material-symbols-outlined">loyalty</span>
  Subscriptions
</Link>

      
<Link to="/saas/payments" className={`menu-item ${isMenuItemActive("/saas/payments") ? "selected" : ""}`}>
  <span className="material-symbols-outlined">loyalty</span>
  Payments
</Link>
        <Link to="/saas/partners" className={`menu-item ${isMenuItemActive("/saas/partners") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">face</span>          
          Partners
        </Link>
        <Link to="/saas/users" className={`menu-item ${isMenuItemActive("/saas/users") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">account_circle</span>          
          Users
        </Link>
        <Link to="/saas/roles" className={`menu-item ${isMenuItemActive("/saas/roles") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">key</span>          
          Roles
        </Link>
        <Link to="/saas/apps" className={`menu-item ${isMenuItemActive("/saas/apps") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">apps </span>          
          Apps
        </Link>
        {/* ... other main menu items */}
      </div>

      {/* Secondary Menu */}
      <div className="secondary-menu">
        <Link to="/saas/members" className={`menu-item ${isMenuItemActive("/saas/members") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">manage_accounts</span>Admin Users
        </Link>
        <Link to="/saas/settings" className={`menu-item ${isMenuItemActive("/saas/settings") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">settings</span>Settings
        </Link>
        {/* ... other secondary menu items */}
        {renderUserDetails()}
        <Link to="/logout" className={`menu-item ${isMenuItemActive("/settings") ? "selected" : ""}`}>
        Logout
        </Link>
      </div>

    </aside>
  );
};

export default SuperAdminMenu;
