// src/components/common/Menu/index.js
import React from 'react';
import { Link, useLocation } from 'react-router-dom';

const AdminMenu = () => {

  const location = useLocation();
  const userId = localStorage.getItem('user_id');
  const name = localStorage.getItem('name');
  const profileImageUrl = localStorage.getItem('picurl'); // Assuming you store the profile image URL

  const renderUserDetails = () => {
    return (
      <div className="profile-row">
        {profileImageUrl ? (
          <img src={profileImageUrl} alt="Profile" className="profile-image" />
        ) : (
          <span className="profile-placeholder-menu">
            {name.charAt(0).toUpperCase()}
          </span>
        )}
        <span className="user-name-menu"><Link to="/settings">{name}</Link></span>
      </div>
    );
  };
    const isMenuItemActive = (path) => {
      location.pathname.startsWith('/billing')
    return location.pathname.startsWith(path);
  };
  return (
    <aside className="menu">
      {/* Main Menu */}      
      <div className="main-menu">
      <Link to='/' className="logo-text"><img src='/logo_dark.png' /></Link>

        <Link to="/dash" className={`menu-item ${isMenuItemActive("/dash") ? "selected" : ""}`}>
          <span className="material-symbols-outlined">dashboard</span>          
            Dashboard
          </Link>
        <Link to="/agents" className={`menu-item ${isMenuItemActive("/agents") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">share_location</span>          
          Track
        </Link>
        <Link to="/visitors" className={`menu-item ${isMenuItemActive("/visitors") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">explore</span>          
          Task
        </Link>
        <Link to="/apps" className={`menu-item ${isMenuItemActive("/apps") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">search_hands_free</span>          
          Fleet
        </Link>
        <Link to="/interactions" className={`menu-item ${isMenuItemActive("/interactions") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">workspaces</span>          
          Workforce
        </Link>
        <Link to="/interactions" className={`menu-item ${isMenuItemActive("/interactions") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">sentiment_satisfied</span>          
          Customer
        </Link>
        <Link to="/interactions" className={`menu-item ${isMenuItemActive("/interactions") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">paid</span>          
          Payments
        </Link>
        {/* ... other main menu items */}
      </div>

      {/* Secondary Menu */}
      <div className="secondary-menu">
      <Link to="/settings" className={`menu-item ${isMenuItemActive("/settings") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">settings</span>Settings
        </Link>
        <Link to="/members" className={`menu-item ${isMenuItemActive("/members") ? "selected" : ""}`}>
        <span className="material-symbols-outlined">manage_accounts</span>Users
        </Link>
      <Link to="/billing" className={`menu-item ${isMenuItemActive("/billing") ? "selected" : ""}`}>        
      <span className="material-symbols-outlined">deployed_code_account</span> Billing
        </Link>
        {/* ... other secondary menu items */}
        {renderUserDetails()}
      </div>
    </aside>
  );
};

export default AdminMenu;
