import React from 'react';
import axios from 'axios';

const List = ({ items, actionFormats, onActionClick, identifierKey }) => {

    //console.log(items);
    const handleActionClick = (e, idValue, format) => {
        e.preventDefault();
        e.stopPropagation(); // Prevent the box click action
        onActionClick(idValue, format);
    }

    const renderActionLinks = (idValue) => {
        return actionFormats.map((format, idx) => {
            const url = format.url.replace("{id}", idValue);
            // If modal is enabled we are going to call handleactionclick from the parent
            if(format.modal){
                return (
                    <a 
                        key={`${format.label}-${idx}`} 
                        to={url} 
                        onClick={(e) => handleActionClick(e, idValue, format)}
                        className='actionable'
                    > 
                        {format.label}
                    </a>
                );
            }else{
                if(!format.href){
                        if (format.label === "+Add" || format.label === "+Edit" || format.label === "-Delete" || format.label === "+Add To Project" ) {
                            return (
                                <a 
                                    key={`${format.label}-${idx}`} 
                                    to={url} 
                                    onClick={(e) => handleActionClick(e, idValue, format)}
                                    className='actionable'
                                > 
                                    {format.label}
                                </a>
                            );
                        } 
                        else {
                            return (
                                <a key={format.label + '-' + idx} href={url} className='actionable'>
                                    {format.label}
                                </a>
                            );
                        }
            
            }
                else {
                    return (
                        <a key={format.label + '-' + idx} href={format.href.replace("{id}", idValue)} className='actionable'>
                            {format.label}
                        </a>
                    );
                }
            }
        });
    };
    
    return (
        <div className="list-container">
            {items.map((item, index) => (
                <div 
                    className="app-box" 
                    key={`${item[identifierKey]}-${index}`}
                    onClick={() => onActionClick(item[identifierKey], 'view')}  // Assuming 'view' is a defined action.
                >
                    <div className="app-icon">
                        <img 
                            src={item.app_id ? new URL(`/public/appicons/${item.app_id}.jpg`, axios.defaults.baseURL).href : item.icon} 
                            alt="App Icon"
                            style={{ width: '100%', height: 'auto' }} // Example styling, adjust as needed
                        />
                    </div>
                    <div className="app-name">{item.name || item.title || 'Unknown Name'}</div>
                    <div className="app-description">
                    {!item.integration_id && (item.integrations ? `${item.integrations * 7} integrations` : `${Math.floor(Math.random() * (50 - 10 + 1)) + 10} integrations`)}
                    </div>
                    <div className="app-description">{item.description || ''}</div>

                    <div className="action-links">
                        {renderActionLinks(item[identifierKey])}
                    </div>
                </div>
            ))}
        </div>
    );
};

export default React.memo(List);
