import React from 'react';
import { Link, useLocation } from 'react-router-dom';
import '../../themes/blue/Header.css';

const Header = () => {
  const location = useLocation();
  const userId = localStorage.getItem('user_id');
  const name = localStorage.getItem('name');
  const profileImageUrl = localStorage.getItem('picurl');

  // Determine if we're on the home page
  const isHomePage = location.pathname === '/';

  // Set header styles for the home page; otherwise, use CSS defaults.
  const headerStyle = isHomePage ? { background: '#000', border: '0px' } : {};
  // Use white logo on the home page; otherwise, use the dark logo.
  const logoSrc = isHomePage ? '/logo_white.png' : '/logo_dark.png';
  // Link style: force white color on home page, let CSS handle otherwise.
  const linkStyle = isHomePage ? { color: '#fff' } : {};

  const renderUserDetails = () => {
    if (profileImageUrl) {
      return <img src={profileImageUrl} alt="Profile" className="profile-image" />;
    } else {
      return (
        <div className="profile-placeholder">
          {name && name.charAt(0).toUpperCase()}
        </div>
      );
    }
  };

  return (
    <header className="header" style={headerStyle}>
      <div className="header-left">
        <Link to="/" className="logo-text">
          <img src={logoSrc} alt="logo" />
        </Link>
        <nav>
          {userId ? (
            <Link to="/dash" style={linkStyle}>Dashboard</Link>
          ) : (
            <>
              <Link to="/how-it-works" style={linkStyle}>Platform</Link>
              <Link to="/applications" style={linkStyle}>Industries</Link>
              <Link to="/pricing" style={linkStyle}>Pricing</Link>
              <Link to="/about" style={linkStyle}>Story</Link>
            </>
          )}
        </nav>
      </div>
      <div className="header-right">
        <Link to="/experience" style={linkStyle}>
          <span className="material-symbols-outlined" style={{ marginRight: '5px' }}>deployed_code</span>
          Request Demo
        </Link>
        {userId ? (
          <>
            {renderUserDetails()}
            <span className="user-name">
              <Link to="/settings" style={linkStyle}>{name}</Link>
            </span>
            <Link to="/logout" style={linkStyle}>Logout</Link>
          </>
        ) : (
          <>
            <Link to="/contact" style={linkStyle}>Contact Us</Link>
            <Link to="/login" style={linkStyle}>Login</Link>
          </>
        )}
      </div>
    </header>
  );
};

export default Header;
