import React, { useState } from 'react';
import { Link, useNavigate, useLocation } from 'react-router-dom';
import '../../themes/blue/PageHeader.css';

const PageHeader = ({ description }) => {
  const navigate = useNavigate();
  const location = useLocation();
  const [showDropdown, setShowDropdown] = useState(false);
  const [isLive, setIsLive] = useState(true);
  const name = localStorage.getItem('name');
  const picurl = localStorage.getItem('picurl');

  // Map routes to page titles
  const pageTitles = {
    '/fleet': 'Fleet',
    '/workforce': 'Workforce',
    '/services': 'Services',
    '/schedules': 'Schedule',
    '/customers': 'Customers',
    '/jobs': 'Task',
    '/marketplace': 'Marketplace',
    '/users': 'Users',
    '/settings': 'Settings'
    // Add more routes as needed
  };

  // Get current page title based on route
  const getPageTitle = () => {
    return pageTitles[location.pathname] || 'Dashboard'; // Default fallback
  };

  const handleLogout = () => navigate('/logout');

  return (
    <div className="PageHeader">
      <div className="header-left">
        <h2 className="page-title">
          <span className="material-symbols-outlined">chevron_right</span>
          {getPageTitle()}
        </h2>
        {description && <p>{description}</p>}
      </div>

      <div className="header-right">
        <div className="toggle-container">
          <span>{isLive ? 'Live' : 'Trial'}</span>
          <label className="switch">
            <input type="checkbox" checked={isLive} onChange={() => setIsLive(!isLive)} />
            <span className="slider"></span>
          </label>
        </div>
        <Link to="/help">
          <span className="material-symbols-outlined">help</span>
        </Link>

        <div className="profile-row-page-header" onClick={() => setShowDropdown(!showDropdown)}>
          <span className="material-symbols-outlined">settings</span>
          {showDropdown && (
            <div className="dropdown-menu">
              <Link className="link" to="/settings">Profile Settings</Link>
              <Link className="link" to="/logout">Logout</Link>
            </div>
          )}
        </div>
      </div>
    </div>
  );
};

export default PageHeader;