
import React, { useEffect } from 'react';
import { Link, useNavigate } from 'react-router-dom';

const Aheader = () => {
  const userId = localStorage.getItem('user_id');
  const name = localStorage.getItem('name');
  const profileImageUrl = localStorage.getItem('picurl');
  const user_roles = localStorage.getItem('roles');
  const navigate = useNavigate();

  useEffect(() => {
    if (user_roles != 1) {
      //console.log("user_ROLES::" + user_roles);
      navigate('/logout');
    }
  }, [user_roles, navigate]); // Dependencies array includes user_roles and navigate


  const renderUserDetails = () => {
    if (profileImageUrl) {
      return <img src={profileImageUrl} alt="Profile" className="profile-image" />;
    } else {
      return (
        <div className="profile-placeholder">
          {name.charAt(0).toUpperCase()}
        </div>
      );
    }
  };

  return (
    <header className="header">
      <div className="header-left">
        <Link to='/' className="logo-text"><span className="material-symbols-outlined">filter_vintage</span>Thought</Link>
      </div>
      <div className="header-right">
        {userId ? (
          <>
            {renderUserDetails()}
            <span className="user-name"> <Link to="/settings">{name} :admin</Link> </span> 
             &nbsp;<Link to="/logout">Logout</Link>
          </>
        ) : (
          <Link to="/login">Login</Link>
        )}
      </div>
    </header>
  );
};

export default Aheader;
