import React from 'react';
import TestForm from './TestForm'; // adjust the path if necessary

const FormsPage = () => {
  // Sample data for the edit form, including two addresses.
  const sampleEditData = {
    firstName: "Alice",
    lastName: "Doe",
    age: 30,
    flightNumber: "FL1234",
    tripType: "return",
    departureDate: "2025-03-01",
    returnDate: "2025-03-15",
    destination: "Canada",
    location: "Toronto, Canada",
    addresses: [
      { street: "123 Maple St", city: "Toronto" },
      { street: "456 Oak Ave", city: "Ottawa" }
    ]
  };

  return (
    <div style={{ padding: "20px" }}>
      <h2>New Form</h2>
      <TestForm onDataChange={(data) => console.log("New Form Data:", data)} />

      <hr style={{ margin: "40px 0" }} />

      <h2>Edit Form</h2>
      <TestForm
        initialData={sampleEditData}
        onDataChange={(data) => console.log("Edit Form Data:", data)}
      />
    </div>
  );
};

export default FormsPage;
