import React, { useState } from 'react';
import TaskUpdate from '../pages/Jobs/TaskUpdate';
import TaskView from '../pages/Jobs/TaskView';
import TaskDB from '../pages/Jobs/TaskDB';
import SearchPage from './SearchPage';
import List from './List';
// import '../../themes/blue/Tasks.css';

const TASKS_HEADER_TO_KEY_MAP = {
    "Task Mode": "task_mode",
    "Priority": "priority",
    "Capacity": "capacity",
   // "Round Trip": "roundtrip",
    "Created Date": "created_date",
    "Status": "status",
};

const CommonTaskList = ({ 
    initialSearchQuery = '', 
    rowsPerPage = 10,
    presetFilters = {} // { vehicle_id: 'xyz', customer_id: 'abc', workforce_id: '123' }
}) => {
    const account_id = localStorage.getItem('account_id');
    const [selectedTask, setSelectedTask] = useState(null);

    // Build the API URL with dynamic filters
    const buildFetchUrl = (baseParams = {}) => {
        const params = new URLSearchParams({
            account_id,
            // skip: baseParams.skip || 0,
            // limit: baseParams.limit || rowsPerPage,
            // q: baseParams.q || initialSearchQuery,
            ...presetFilters // This injects vehicle_id/customer_id/workforce_id if provided
        });

        // Ensure all filter keys exist in URL even if empty
        ['workforce_id', 'vehicle_id', 'customer_id'].forEach(key => {
            if (!params.has(key)) params.set(key, '');
        });

        return `/tasks/?${params.toString()}`;
     

    };

    const actionFormats = [
        { label: "View", modal: true, url: "/tasks/view/{id}", icon: "visibility" },
        { label: "Edit", modal: true, url: "/tasks/update/{id}", icon: "edit" },
        { label: "Delete", modal: true, url: "/tasks/delete/{id}", icon: "delete", color: "error" }
    ];

    const handleActionClick = (taskId, action) => {
        if (["View", "Edit", "Delete"].includes(action.label)) {
            setSelectedTask({ taskId, modalType: action.label.toLowerCase() });
        }
    };

    const closeModal = () => setSelectedTask(null);

    return (
        <div className="tasks-list-container">
            <SearchPage
                fetchDataUrl={buildFetchUrl()}
                ListComponent={List}
                itemKeyMapping={TASKS_HEADER_TO_KEY_MAP}
                dataKey="users"
                identifierKey="task_id"
                initialSearchQuery={initialSearchQuery}
                rowsPerPage={rowsPerPage}
                actionFormats={actionFormats}
                onActionClick={handleActionClick}
                searchPlaceholder="Search tasks by priority or mode"
                buildFetchUrl={buildFetchUrl} // Pass the URL builder
            />

            {selectedTask?.modalType === "view" && (
                <TaskView taskId={selectedTask.taskId} onClose={closeModal} />
            )}
            {selectedTask?.modalType === "update" && (
                <TaskUpdate taskId={selectedTask.taskId} onClose={closeModal} />
            )}
            {selectedTask?.modalType === "delete" && (
                <TaskDB taskId={selectedTask.taskId} onClose={closeModal} />
            )}
        </div>
    );
};

export default CommonTaskList;

