

import { useState, useEffect } from 'react';
import axios from 'axios';

function useCommonEnums() {
    const [enumData, setEnumData] = useState(null);
    const [loading, setLoading] = useState(true);
    const [error, setError] = useState(null);

    useEffect(() => {
        const cached = localStorage.getItem('enumData');

        const fetchFromServer = async () => {
            try {
                const response = await axios.get('/common/');
                const transformed = transformData(response.data || {});
                localStorage.setItem('enumData', JSON.stringify(transformed));
                setEnumData(transformed);
            } catch (err) {
                console.error("Error fetching enums:", err);
                setError(err);
            } finally {
                setLoading(false);
            }
        };

        if (cached) {
            try {
                const parsed = JSON.parse(cached);
                setEnumData(transformData(parsed));
                setLoading(false);
            } catch (parseErr) {
                console.error("Invalid cache:", parseErr);
                localStorage.removeItem('enumData');
                fetchFromServer();
            }
        } else {
            fetchFromServer();
        }

        function transformData(data) {
            return {
                // Use the exact property names that Setup.js expects
                industries: data.Industry || data.industries || [],
                purposes_of_use: data.PurposeOfUse || data.purposes_of_use || [],
                fleet_capabilities: data.FleetCapability || data.fleet_capabilities || [],
                workforce_capabilities: data.WorkforceCapability || data.workforce_capabilities || [],
                workforce_range: data.WorkforceCountRange || data.workforce_range || [],
                fleet_count_range: data.FleetCountRange || data.fleet_count_range || [],
             
                revenues: data.RevenueRange || data.revenues || [],
                invoice_status: data.InvoiceStatus || data.invoice_status || []
            };
        }
    }, []);

    return { enums: enumData, loading, error };
}

export default useCommonEnums;