import React, { useState, useEffect } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';


const View = ({ collectionName, itemId, onClose, renderItem }) => {
  const [itemData, setItemData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');


  useEffect(() => {
    axios.get(`/crud/${collectionName}/${itemId}`)
      .then(res => {
        let data = res.data;


        // If response is wrapped in 'items', extract first item
        if (data?.items && Array.isArray(data.items)) {
          data = data.items[0];
        }


        // Map pricing_type to name
        if (collectionName === 'pricing_types' && data?.pricing_type) {
          data.name = data.pricing_type;
        }


        setItemData(data);
        setLoading(false);
      })
      .catch(() => {
        setError(`Error fetching ${collectionName} data.`);
        setLoading(false);
      });
  }, [collectionName, itemId]);


  const getAvatarLetter = (name) => {
    return name ? name.charAt(0).toUpperCase() : '';
  };


  const displayName = itemData?.name || 'N/A';


  return (
    <Modal title={''} onClose={onClose}>
      {loading ? (
        <div>Loading...</div>
      ) : error ? (
        <div style={{ color: 'red' }}>{error}</div>
      ) : (
        renderItem ? renderItem(itemData) : (
          <div style={{ padding: '20px' }}>
            {/* Profile Section */}
            <div style={{
              display: 'flex',
              alignItems: 'center',
              marginBottom: '30px',
              paddingBottom: '20px',
              borderBottom: '1px solid #e0e0e0'
            }}>
              <div style={{
                width: '60px',
                height: '60px',
                borderRadius: '50%',
                backgroundColor: '#e0e0e0',
                color: 'black',
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                fontSize: '24px',
                fontWeight: 'bold',
                marginRight: '20px'
              }}>
                {getAvatarLetter(displayName)}
              </div>
              <div>
                <div style={{
                  fontSize: '20px',
                  fontWeight: 'bold',
                  marginBottom: '5px',
                  color: 'black'
                }}>
                  {displayName}
                </div>
                <div style={{
                  color: 'black',
                  fontSize: '14px',
                  fontWeight: 'bold'
                }}>
                  ID: #{itemId}
                </div>
              </div>
            </div>


            {/* Details Section */}
            <div style={{ paddingTop: '15px' }}>
              <div style={{ marginBottom: '15px', display: 'flex' }}>
                <div style={{
                  fontWeight: 'bold',
                  width: '120px',
                  color: '#666'
                }}>
                  Name:
                </div>
                <div>{displayName}</div>
              </div>


              <div style={{ marginBottom: '15px', display: 'flex' }}>
                <div style={{
                  fontWeight: 'bold',
                  width: '120px',
                  color: '#666'
                }}>
                  Status:
                </div>
                <div>{itemData?.status || 'N/A'}</div>
              </div>
            </div>
          </div>
        )
      )}
    </Modal>
  );
};


export default View;