import React, { useState } from 'react';
import Modal from '../../Layouts/Modal';
import GenericForm from './Form';

const Update = ({ collectionName, title, itemId, schema, uiSchema, onSuccess, onClose }) => {
  const [errorMessage, setErrorMessage] = useState('');

  // Handle success with window.alert
  const handleSuccess = () => {
    window.alert(`${title} updated successfully!`);
    if (onSuccess) {
      onSuccess();
    }
    onClose();
  };

  // Handle errors from GenericForm
  const handleError = (error) => {
    if (error?.response?.data?.message?.includes("already exists")) {
      setErrorMessage(`An ${title.toLowerCase()} with this name already exists.`);
    } else {
      setErrorMessage("An unexpected error occurred. Please try again.");
    }
  };

  return (
    <Modal title={`Edit ${title}`} onClose={onClose}>
      {errorMessage && (
        <div style={{ color: 'red', background: '#ffe5e5', padding: '10px', marginBottom: '15px', borderRadius: '5px' }}>
          {errorMessage}
        </div>
      )}
      <GenericForm
        collectionName={collectionName}
        itemId={itemId}
        schema={schema}
        uiSchema={uiSchema}
        method="PUT"
        onSuccess={handleSuccess}
        onError={handleError}  // <-- attach error handler here
      />
    </Modal>
  );
};

export default Update;
