import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const Delete = ({ collectionName, title, itemId, onSuccess, onClose }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [statusMessage, setStatusMessage] = useState('');

  const handleDelete = () => {
    if (isSubmitting) return;

    setSubmitting(true);
    axios.delete(`/crud/${collectionName}/${itemId}`)
      .then(res => {
        window.alert(`${title} deleted successfully.`); // Changed to browser alert
        if (onSuccess) onSuccess();
        onClose(); // Close the modal after successful deletion
      })
      .catch(err => {
        setStatusMessage(`Error deleting ${title}.`);
      })
      .finally(() => {
        setSubmitting(false);
      });
  };

  return (
    <Modal title={`Delete ${title}`} onClose={onClose}>
      {statusMessage ? (
        <p className="status-message">{statusMessage}</p>
      ) : (
        <>
          <p>Are you sure you want to delete this {title}?</p>
          <div className="button-group" style={{ 
            display: 'flex', 
            gap: '16px',
            marginTop: '20px',
            justifyContent: 'flex-start'
          }}>
            <button 
              onClick={handleDelete} 
              disabled={isSubmitting}
              style={{
                padding: '8px 24px',
                backgroundColor: '#f0f0f0',
                color: '#28C76F',
                border: '1px solid white',
                borderRadius: '6px',
                cursor: isSubmitting ? 'not-allowed' : 'pointer',
                fontWeight: 600,
                fontSize: '14px',
                minWidth: '100px',
                opacity: isSubmitting ? 0.6 : 1,
                transition: 'all 0.3s ease'
              }}
              onMouseOver={(e) => {
                if (!isSubmitting) {
                  e.currentTarget.style.backgroundColor = '#28C76F';
                  e.currentTarget.style.color = '#f0f0f0';
                }
              }}
              onMouseOut={(e) => {
                if (!isSubmitting) {
                  e.currentTarget.style.backgroundColor = '#f0f0f0';
                  e.currentTarget.style.color = '#28C76F';
                }
              }}
            >
              {isSubmitting ? 'Deleting...' : 'Confirm'}
            </button>

            <button 
              onClick={onClose}
              disabled={isSubmitting}
              style={{
                padding: '8px 24px',
                backgroundColor: '#f0f0f0',
                color: '#28C76F',
                border: '1px solid white',
                borderRadius: '6px',
                cursor: isSubmitting ? 'not-allowed' : 'pointer',
                fontWeight: 600,
                fontSize: '14px',
                minWidth: '100px',
                opacity: isSubmitting ? 0.6 : 1,
                transition: 'all 0.3s ease'
              }}
              onMouseOver={(e) => {
                if (!isSubmitting) {
                  e.currentTarget.style.backgroundColor = '#28C76F';
                  e.currentTarget.style.color = '#f0f0f0';
                }
              }}
              onMouseOut={(e) => {
                if (!isSubmitting) {
                  e.currentTarget.style.backgroundColor = '#f0f0f0';
                  e.currentTarget.style.color = '#28C76F';
                }
              }}
            >
              Cancel
            </button>
          </div>
        </>
      )}
    </Modal>
  );
};

export default Delete;