import React, { useState } from 'react';
import Tabs from '../Tabs';
import PageHeader from '../Header/PageHeader';
import CrudList from './CrudList';
import Add from './Add';
import Update from './Update';
import Delete from './Delete';
import View from './View';
import { Box } from '@mui/material';

const CrudModule = ({
  collectionName,
  title,
  description,
  headerMapping,
  dataKey,
  identifierKey,
  schema,
  uiSchema,
  fetchUrl,
  searchFields,
  rowsPerPage = 10,
  actionFormats,
}) => {
  const tabsData = [
    { id: 'list', label: `List` },
    { id: 'new', label: `Add` },
  ];

  const [selectedModal, setSelectedModal] = useState(null);

  const handleActionClick = (itemId, action) => {
    setSelectedModal({ itemId, modalType: action.label.toLowerCase() });
  };

  const closeModal = () => setSelectedModal(null);

  return (
    <div className={`${collectionName.toLowerCase()}-container`}>
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          if (activeTab === 'list') {
            return (
              <CrudList
                collectionName={collectionName}
                headerToKeyMap={headerMapping}
                dataKey={dataKey}
                identifierKey={identifierKey}
                searchFields={searchFields}
                rowsPerPage={rowsPerPage}
                actionFormats={actionFormats}
                onActionClick={handleActionClick}
                fetchUrl={fetchUrl}
              />
            );
          }
          if (activeTab === 'new') {
            return (
              <Box sx={{ 
                paddingLeft: '20px',  // Shift only the Add section right
                paddingTop: '20px',
                width: '100%'
              }}>
                <Add
                  collectionName={collectionName}
                  schema={schema}
                  uiSchema={uiSchema}
                />
              </Box>
            );
          }
          return null;
        }}
      </Tabs>

      {selectedModal && selectedModal.modalType === 'view' && (
        <View
          collectionName={collectionName}
          title={title}
          itemId={selectedModal.itemId}
          onClose={closeModal}
        />
      )}
      {selectedModal && (selectedModal.modalType === 'edit' || selectedModal.modalType === 'update') && (
        <Update
          collectionName={collectionName}
          title={title}
          itemId={selectedModal.itemId}
          schema={schema}
          uiSchema={uiSchema}
          onClose={closeModal}
        />
      )}
      {selectedModal && selectedModal.modalType === 'delete' && (
        <Delete
          collectionName={collectionName}
          title={title}
          itemId={selectedModal.itemId}
          onClose={closeModal}
        />
      )}
    </div>
  );
};

export default CrudModule;


// import React, { useState } from 'react';
// import Tabs from '../Tabs';
// import PageHeader from '../Header/PageHeader';
// import CrudList from './CrudList';
// import Add from './Add';
// import Update from './Update';
// import Delete from './Delete';
// import View from './View';
// import { Box } from '@mui/material';

// const CrudModule = ({
//   collectionName,
//   title,
//   description,
//   headerMapping,
//   dataKey,
//   identifierKey,
//   schema,
//   uiSchema,
//   fetchUrl,
//   searchFields,
//   filterOptions = [],
//   rowsPerPage = 10,
//   actionFormats,
// }) => {
//   const tabsData = [
//     { id: 'list', label: `List` },
//     { id: 'new', label: `Add` },
//   ];

//   const [selectedModal, setSelectedModal] = useState(null);
//   const [activeFilters, setActiveFilters] = useState({});

//   const handleActionClick = (itemId, action) => {
//     setSelectedModal({ itemId, modalType: action.label.toLowerCase() });
//   };

//   const closeModal = () => setSelectedModal(null);

//   const handleFilterChange = (filterName, value) => {
//     setActiveFilters(prev => ({
//       ...prev,
//       [filterName]: value
//     }));
//   };

//   const clearFilters = () => {
//     setActiveFilters({});
//   };

//   const buildFetchUrlWithFilters = () => {
//     if (Object.keys(activeFilters).length === 0) {
//       return fetchUrl;
//     }

//     const params = new URLSearchParams();
//     Object.entries(activeFilters).forEach(([key, value]) => {
//       if (value) {
//         params.append(key, value);
//       }
//     });

//     return `${fetchUrl}${fetchUrl.includes('?') ? '&' : '?'}${params.toString()}`;
//   };

//   // Render filter section in the style of the first screenshot
//   const renderFilterSection = () => {
//     if (!filterOptions || filterOptions.length === 0) return null;

//     return (
//       <Box sx={{ 
//         padding: '16px', 
//         marginBottom: '16px', 
//         border: '1px solid #e0e0e0', 
//         borderRadius: '4px',
//         backgroundColor: '#f8f9fa'
//       }}>
//         <Box sx={{ 
//           display: 'flex', 
//           alignItems: 'center', 
//           justifyContent: 'space-between',
//           marginBottom: '12px' 
//         }}>
//           <strong style={{ fontSize: '14px', color: '#555' }}>FILTERS</strong>
//           {Object.keys(activeFilters).length > 0 && (
//             <button 
//               onClick={clearFilters}
//               style={{ 
//                 padding: '4px 12px', 
//                 fontSize: '12px',
//                 backgroundColor: '#6c757d',
//                 color: 'white',
//                 border: 'none',
//                 borderRadius: '3px',
//                 cursor: 'pointer'
//               }}
//             >
//               Clear All
//             </button>
//           )}
//         </Box>
        
//         <Box sx={{ 
//           display: 'flex', 
//           flexWrap: 'wrap', 
//           gap: '8px',
//           alignItems: 'center'
//         }}>
//           {filterOptions.map((filter) => (
//             <Box key={filter.name} sx={{ 
//               display: 'flex', 
//               alignItems: 'center',
//               gap: '4px'
//             }}>
//               <span style={{ 
//                 padding: '4px 8px', 
//                 backgroundColor: '#007bff', 
//                 color: 'white', 
//                 borderRadius: '3px',
//                 fontSize: '12px',
//                 fontWeight: '500',
//                 cursor: 'pointer'
//               }}>
//                 + {filter.label}
//               </span>
              
//               {filter.type === 'select' && (
//                 <select
//                   value={activeFilters[filter.name] || ''}
//                   onChange={(e) => handleFilterChange(filter.name, e.target.value)}
//                   style={{ 
//                     padding: '4px 8px', 
//                     border: '1px solid #ddd', 
//                     borderRadius: '3px',
//                     fontSize: '12px',
//                     minWidth: '120px'
//                   }}
//                 >
//                   <option value="">Select {filter.label}</option>
//                   {filter.options.map(option => (
//                     <option key={option.value} value={option.value}>
//                       {option.label}
//                     </option>
//                   ))}
//                 </select>
//               )}
              
//               {filter.type === 'date' && (
//                 <input
//                   type="date"
//                   value={activeFilters[filter.name] || ''}
//                   onChange={(e) => handleFilterChange(filter.name, e.target.value)}
//                   placeholder={filter.placeholder}
//                   style={{ 
//                     padding: '4px 8px', 
//                     border: '1px solid #ddd', 
//                     borderRadius: '3px',
//                     fontSize: '12px',
//                     minWidth: '120px'
//                   }}
//                 />
//               )}
              
//               {filter.type === 'text' && (
//                 <input
//                   type="text"
//                   value={activeFilters[filter.name] || ''}
//                   onChange={(e) => handleFilterChange(filter.name, e.target.value)}
//                   placeholder={filter.placeholder}
//                   style={{ 
//                     padding: '4px 8px', 
//                     border: '1px solid #ddd', 
//                     borderRadius: '3px',
//                     fontSize: '12px',
//                     minWidth: '120px'
//                   }}
//                 />
//               )}
//             </Box>
//           ))}
//         </Box>
//       </Box>
//     );
//   };

//   return (
//     <div className={`${collectionName.toLowerCase()}-container`}>
//       <Tabs tabs={tabsData}>
//         {(activeTab) => {
//           if (activeTab === 'list') {
//             return (
//               <Box>
//                 {renderFilterSection()}
//                 <CrudList
//                   collectionName={collectionName}
//                   headerToKeyMap={headerMapping}
//                   dataKey={dataKey}
//                   identifierKey={identifierKey}
//                   searchFields={searchFields}
//                   rowsPerPage={rowsPerPage}
//                   actionFormats={actionFormats}
//                   onActionClick={handleActionClick}
//                   fetchUrl={buildFetchUrlWithFilters()}
//                   activeFilters={activeFilters}
//                 />
//               </Box>
//             );
//           }
//           if (activeTab === 'new') {
//             return (
//               <Box sx={{ 
//                 paddingLeft: '20px',
//                 paddingTop: '20px',
//                 width: '100%'
//               }}>
//                 <Add
//                   collectionName={collectionName}
//                   schema={schema}
//                   uiSchema={uiSchema}
//                 />
//               </Box>
//             );
//           }
//           return null;
//         }}
//       </Tabs>

//       {selectedModal && selectedModal.modalType === 'view' && (
//         <View
//           collectionName={collectionName}
//           title={title}
//           itemId={selectedModal.itemId}
//           onClose={closeModal}
//         />
//       )}
//       {selectedModal && (selectedModal.modalType === 'edit' || selectedModal.modalType === 'update') && (
//         <Update
//           collectionName={collectionName}
//           title={title}
//           itemId={selectedModal.itemId}
//           schema={schema}
//           uiSchema={uiSchema}
//           onClose={closeModal}
//         />
//       )}
//       {selectedModal && selectedModal.modalType === 'delete' && (
//         <Delete
//           collectionName={collectionName}
//           title={title}
//           itemId={selectedModal.itemId}
//           onClose={closeModal}
//         />
//       )}
//     </div>
//   );
// };

// export default CrudModule;