import React from 'react';
import SearchPage from '../SearchPage';
import List from '../List';


const CrudList = ({
  collectionName,
  headerToKeyMap,
  dataKey,
  identifierKey,
  initialSearchQuery = '',
  rowsPerPage = 10,
  actionFormats,
  onActionClick,
  searchFields,
  fetchUrl, // Optional: if not provided, we'll construct one.
}) => {
  const fetchDataUrl = fetchUrl || `/crud/${collectionName}/`;


  return (
    <div>
      <SearchPage
        fetchDataUrl={fetchDataUrl}
        ListComponent={List}
        itemKeyMapping={headerToKeyMap}
        dataKey={dataKey}
        identifierKey={identifierKey}
        initialSearchQuery={initialSearchQuery}
        rowsPerPage={rowsPerPage}
        actionFormats={actionFormats}
        onActionClick={onActionClick}
        searchFields={searchFields}
      />
    </div>
  );
};


export default CrudList;