import React from 'react';
import GenericForm from './Form';

const Add = ({ collectionName, schema, uiSchema, onSuccess, onClose }) => {
  
  // Handle success with window.alert
  const handleSuccess = () => {
    window.alert(`${collectionName} added successfully!`);
    if (onSuccess) {
      onSuccess();
    }
  };

  return (
    <GenericForm
      collectionName={collectionName}
      schema={schema}
      uiSchema={uiSchema}
      onSuccess={handleSuccess}
      hideOnSuccess={true}
    />
  );
};

export default Add;
