import React from 'react';
import Field from './Field';

const FormStep = ({ fields, formType, formData, onInputChange }) => {
    return (
        <div className={formType === 'chat' ? 'chat-step' : 'regular-step'}>
            {fields.map(field => (
                <Field 
                    key={field.name}
                    type={field.type}
                    name={field.name}
                    placeholder={field.placeholder}
                    options={field.options}
                    mandatory={field.mandatory}
                    minlength={field.minlength}
                    label={field.label}
                    rows={field.rows}
                    //value={formData[field.name] || field.value}
                    value={formData[field.name] !== undefined ? formData[field.name] : field.value}
                    checked={field.type === 'checkbox' ? formData[field.name] : undefined}
                    //onChange={field.onchange || onInputChange}
                    onChange={onInputChange}
                />
            ))}
        </div>
    );
};

export default FormStep;
