import React from 'react';

const Field = ({ type, name, placeholder, options, mandatory, minlength, onChange, value, maxEntries = 1, label ="", rows, checked, onFileChange }) => {

    const handleChange = (e, index = 0) => {
        if (type === 'file') {
            onFileChange && onFileChange(e);
            const file = e.target.files[0];
            onChange(name, file);
            return;
        }
        if (type === 'checkbox') {
            //console.log(e.target.checked);
            onChange(name, e.target.checked); // Use 'checked' for checkboxes
            return;
        }

        if (Array.isArray(value) && type !== 'select') {
            const newValue = [...value];
            newValue[index] = e.target.value;   
            onChange(name, newValue);
        } else {
            onChange(name, e.target.value);
        }
    };

    if (Array.isArray(value) && type !== 'select') {
        return value.map((val, index) => (
            <div key={index}>
                <input 
                    type={type} 
                    placeholder={placeholder} 
                    value={val} 
                    onChange={(e) => handleChange(e, index)}
                    required={mandatory} 
                    minLength={minlength} 
                />
                {index < maxEntries - 1 && (
                    <button onClick={() => {
                        const newValue = [...value];
                        newValue.push('');
                        onChange(name, newValue);
                    }}>Add Another</button>
                )}
            </div>
        ));
    }

    return (
        <>
            {label && <label>{label}<br /></label>}
            {(() => {
                switch (type) {
                    case 'textarea':
                        return (
                            <textarea
                                name={name}
                                placeholder={placeholder}
                                onChange={(e) => handleChange(e)}
                                value={value || ""}
                                required={mandatory}
                                minLength={minlength}
                                rows={rows}
                            ></textarea>
                        );
                    case 'select':
                        return (
                            <select name={name} onChange={(e) => handleChange(e)} value={value} required={mandatory}>
                                <option value="">{placeholder}</option>
                                {options.map(opt => (
                                    <option key={opt.value} value={opt.value}>
                                        {opt.label}
                                    </option>
                                ))}
                            </select>
                        );
                    case 'email':
                        return (
                            <input 
                                type="email" 
                                name={name} 
                                placeholder={placeholder} 
                                onChange={(e) => handleChange(e)} 
                                value={value} 
                                required={mandatory} 
                                minLength={minlength} 
                                pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$" 
                            />
                        );
                    case 'file':
                        return (
                            <div>
                                <input 
                                    type="file" 
                                    name={name} 
                                    onChange={(e) => handleChange(e)}
                                    required={mandatory}
                                />
                            </div>
                        );
                    case 'checkbox':
                        return (
                            <input 
                                type={type} 
                                name={name} 
                                //onChange={handleChange} 
                                required={mandatory} 
                                checked={!!checked}
                                onChange={handleChange}
                             />
                        );
                    default:
                        return (
                            <input 
                                type={type} 
                                name={name} 
                                placeholder={placeholder} 
                                onChange={(e) => handleChange(e)} 
                                value={value || ""} 
                                required={mandatory} 
                                minLength={minlength}
                            />
                        );
                }
            })()}
        </>
    );
};

export default Field;
