// src/components/pages/VehicleCategory.js
import React from 'react';
import CrudModule from '../common/CRUD/CrudModule';

// JSON schema for Vehicle Category form
const vehicleCategorySchema = {
  title: "Vehicle Category",
  type: "object",
  required: ["name"],
  properties: {
    name: { type: "string", title: "Category Name" },
    rate: { type: "number", title: "Rate" },
    unit: { type: "string", title: "Unit" },
    base_rate: { type: "number", title: "Base Rate" },
  }
};

// UI schema for Vehicle Category form
const vehicleCategoryUiSchema = {
  name: { "ui:placeholder": "Enter category name" },
  rate: { "ui:placeholder": "Enter rate" },
  unit: { "ui:placeholder": "Enter unit (e.g., per km, per hour)" },
  base_rate: { "ui:placeholder": "Enter base rate" },
};

const VehicleCategory = () => {
  return (
    <CrudModule
      collectionName="dummyvehiclecategory"
      title="Vehicle Category"
      description="Manage vehicle categories and rates."
      headerMapping={{
        "Name": "name",
        "Rate": "rate",
        "Unit": "unit",
        "Base Rate": "base_rate",
        "Created Date": "created_date",
      }}
      dataKey="items"
      identifierKey="dummyvehiclecategory_id"  // Ensure this matches your backend ID field
      schema={vehicleCategorySchema}
      uiSchema={vehicleCategoryUiSchema}
      fetchUrl="/crud/dummyvehiclecategory/"
      searchFields={[
        {
          name: 'q',
          type: 'text',
          placeholder: 'Search vehicle categories...',
        },
      ]}
      rowsPerPage={10}
      actionFormats={[
        { label: "view", modal: true, url: "/vehiclecategory/view/{dummyvehiclecategory_id}" },
        { label: "edit", modal: true, url: "/vehiclecategory/update/{dummyvehiclecategory_id}" },
        { label: "delete", modal: true, url: "/vehiclecategory/delete/{dummyvehiclecategory_id}" },
      ]}
    />
  );
};

export default VehicleCategory;
