import React from 'react';
import { useLocation } from 'react-router-dom';
import Tabs from '../../common/Tabs';
import UsersList from './UsersList';
import AddUser from './AddUser';
import Invite from '../../common/Invite';
import NewRole from '../Roles/AddRole';

const Users = () => {
  const accountId = localStorage.getItem('account_id') || null;

  // Check if current URL contains '/saas/members'
  const location = useLocation();
  const isMembersRoute = location.pathname.includes('/saas/members');

  // Conditionally exclude the "Users" tab
  const tabsData = [
    ...(!isMembersRoute ? [{ id: 'list', label: 'Users' }] : []),
    // { id: 'roles', label: 'Roles' },
    { id: 'new', label: 'Invite' },
  ];

  return (
    <div className="roles-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'list':
              return <UsersList key="users-all" accountId={accountId} />;
              //return <UsersList key="users-my" accountId={accountId} />;
            // case 'roles':
            //   return <NewRole/>;
            case 'new':
              return <Invite key="invite-user" defaultRoleId="9" />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Users;
