import React, { useState, useEffect } from 'react';
import axios from 'axios';
import UserForm from './UserForm';
import Modal from '../../Layouts/Modal';

const UserUpdate = ({ userId, onClose, onUpdateSuccess }) => {
  const [userData, setUserData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');

  useEffect(() => {
    axios.get(`/users/${userId}`)
      .then(res => {
        setUserData(res.data);
        setLoading(false);
      })
      .catch(err => {
        setError('Error fetching user data.');
        setLoading(false);
      });
  }, [userId]);

  const handleSubmit = (formData) => {
    axios.post(`/users/${userId}`, formData)
      .then(res => {
        alert("User updated successfully!");
        if (onUpdateSuccess) onUpdateSuccess(res.data);
        onClose();
      })
      .catch(err => {
        alert("Error updating user.");
      });
  };

  return (
    <Modal title="Edit User" onClose={onClose}>
      {loading ? (
        <div>Loading user data...</div>
      ) : error ? (
        <div style={{ color: 'red' }}>{error}</div>
      ) : (
        <UserForm initialData={userData} onSubmit={handleSubmit} />
      )}
    </Modal>
  );
};

export default UserUpdate;
