import React, { useState } from 'react';
import Form from '@rjsf/core';
import validator from '@rjsf/validator-ajv8';

// JSON schema derived from your User model
export const userSchema = {
  title: "User Form",
  description: "Create or update a user.",
  type: "object",
  required: ["email", "name"],
  properties: {
    email: { type: "string", title: "Email" },
    name: { type: "string", title: "Name" },
    mobile: { type: "string", title: "Mobile" },
    account_id: { type: "string", title: "Account ID" },
    date_of_birth: { type: "string", format: "date", title: "Date of Birth" },
    is_active: { type: "boolean", title: "Active", default: true },
    is_verified: { type: "boolean", title: "Verified", default: true },
    roles: {
      type: "integer",
      title: "Role",
      enum: [1, 2, 3, 4],
      enumNames: ["Admin", "Super Admin", "User", "Guest"],
      default: 2
    }
  }
};

// Optional UI schema tweaks
export const userUiSchema = {
  date_of_birth: {
    "ui:widget": "alt-datetime"
  },
  is_active: {
    "ui:widget": "checkbox"
  },
  is_verified: {
    "ui:widget": "checkbox"
  }
};

const UserForm = ({ initialData, onSubmit }) => {
  const [formData, setFormData] = useState(initialData || {});

  const handleSubmit = ({ formData }) => {
    onSubmit(formData);
  };

  return (
    <div style={{ maxWidth: "600px", margin: "0 auto" }}>
      <Form
        schema={userSchema}
        uiSchema={userUiSchema}
        formData={formData}
        onChange={({ formData }) => setFormData(formData)}
        onSubmit={handleSubmit}
        validator={validator}
        liveValidate
      />
    </div>
  );
};

export default UserForm;
