import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const UserDB = ({ userId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteUser = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    axios.delete(`/users/${userId}`)
      .then(res => {
        alert("User deleted successfully.");
        if (onDeleteSuccess) onDeleteSuccess();
        onClose();
      })
      .catch(err => {
        setError("Error deleting user.");
      })
      .finally(() => {
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete/Block User" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete or block this user?</p>
      <button onClick={deleteUser} disabled={isSubmitting}>Confirm</button>
      <button onClick={onClose}>Cancel</button>
    </Modal>
  );
};

export default UserDB;
