import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import UserForm from './UserForm';

const NewUser = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = (formData) => {
    axios.post(`/users/`, formData)
      .then(res => {
        alert("User created successfully!");
        if (onCreateSuccess) onCreateSuccess(res.data);
        if (onClose) onClose();
      })
      .catch(err => {
        alert("Error creating user.");
      });
  };

  return (
      <UserForm onSubmit={handleSubmit} />
  );
};

export default NewUser;
