import React from 'react';
import Tabs from '../../common/Tabs';
import TicketList from './TicketList';
import AddTicket from './AddTicket';

const Tickets = () => {
    const tabsData = [
        { id: 'ticket_list', label: 'Ticket List' },
        { id: 'new_ticket', label: 'New Ticket' },
    ];

    return (
        <div className="roles-container">
            <Tabs tabs={tabsData}>
                {(activeTab) => {
                    switch (activeTab) {
                        case 'ticket_list':
                            return <TicketList />;
                        case 'new_ticket':
                            return <AddTicket />;
                        default:
                            return null;
                    }
                }}
            </Tabs>
        </div>
    );
};

export default Tickets;


// import React from 'react';
// import Tabs from '../../common/Tabs';
// import TicketList from './TicketList';
// import AddTicket from './AddTicket';

// const Tickets = () => {
//     const role = parseInt(localStorage.getItem('roles'), 10); // Get role from localStorage

//     // Conditionally include the "New Ticket" tab only if role is 5
//   const tabsData = [
//     { id: 'ticket_list', label: 'Ticket List' },
//     ...([3, 4, 5].includes(role) ? [{ id: 'new_ticket', label: 'New Ticket' }] : [])
// ];

//     return (
//         <div className="roles-container">
//             <Tabs tabs={tabsData}>
//                 {(activeTab) => {
//                     switch (activeTab) {
//                         case 'ticket_list':
//                             return <TicketList />;
//                         case 'new_ticket':
//                             return <AddTicket />;
//                         default:
//                             return null;
//                     }
//                 }}
//             </Tabs>
//         </div>
//     );
// };

// export default Tickets;
