// TicketUpdate.js
import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const TicketUpdate = ({ ticketId, onClose, onUpdateSuccess }) => {
    const [description, setDescription] = useState('');
    const [status, setStatus] = useState('open');
    const [isSubmitting, setIsSubmitting] = useState(false);
    const [error, setError] = useState('');

    const handleSubmit = async (e) => {
        e.preventDefault();
        if (!description) {
            setError('Please enter a description');
            return;
        }

        setIsSubmitting(true);
        try {
            const payload = {
                ticket_id: ticketId,
                user_id: localStorage.getItem('user_id'),
                account_id: localStorage.getItem('account_id'),
                description,  // Changed from message to description
                status
            };

            await axios.post('/ticket/reply', payload);
            alert("Reply added successfully!");
            if (onUpdateSuccess) onUpdateSuccess();
            onClose();
        } catch (err) {
            console.error('Error adding reply:', err);
            setError('Error adding reply. Please try again.');
        } finally {
            setIsSubmitting(false);
        }
    };

    return (
        <Modal title="Add Reply to Ticket" onClose={onClose}>
            <form onSubmit={handleSubmit} style={{ padding: '20px' }}>
                {error && <div style={{ color: 'red', marginBottom: '15px' }}>{error}</div>}
                
                <div style={{ marginBottom: '15px' }}>
                    <label style={{ display: 'block', marginBottom: '5px' }}>Status:</label>
                    <select
                        value={status}
                        onChange={(e) => setStatus(e.target.value)}
                        style={{
                            width: '100%',
                            padding: '10px',
                            border: '1px solid #ccc',
                            borderRadius: '4px'
                        }}
                    >
                        <option value="open">Open</option>
                        <option value="in_progress">In Progress</option>
                        <option value="resolved">Resolved</option>
                        <option value="closed">Closed</option>
                    </select>
                </div>
                
                <div style={{ marginBottom: '15px' }}>
                    <label style={{ display: 'block', marginBottom: '5px' }}>Description:</label>
                    <textarea
                        value={description}
                        onChange={(e) => setDescription(e.target.value)}
                        style={{
                            width: '100%',
                            padding: '10px',
                            border: '1px solid #ccc',
                            borderRadius: '4px',
                            minHeight: '150px'
                        }}
                        placeholder="Enter your description..."
                    />
                </div>
                
                <button
                    type="submit"
                    disabled={isSubmitting}
                    style={{
                        backgroundColor: isSubmitting ? '#ccc' : '#4CAF50',
                        color: 'white',
                        padding: '10px 15px',
                        border: 'none',
                        borderRadius: '4px',
                        cursor: 'pointer',
                        fontSize: '16px'
                    }}
                >
                    {isSubmitting ? 'Submitting...' : 'Submit Reply'}
                </button>
            </form>
        </Modal>
    );
};

export default TicketUpdate;