import React, { useEffect } from 'react';
import Form from '@rjsf/core';
import validator from '@rjsf/validator-ajv8';

const baseSchema = {
    type: "object",
    required: ["description"],
    properties: {
        description: { type: "string", title: "Description", default: "" },
        status: { 
            type: "string", 
            title: "Status", 
            enum: ["open", "in_progress", "resolved", "closed"],
            default: "open" 
        }
    }
};

const fullSchema = {
    type: "object",
    required: ["subject", "description", "status"],
    properties: {
        subject: { type: "string", title: "Subject", default: "" },
        questings: { type: "string", title: "Questions", default: "" },
        description: { type: "string", title: "Description", default: "" },
        comment: { type: "string", title: "Initial Comment", default: "" },
        status: { 
            type: "string", 
            title: "Status", 
            enum: ["open", "in_progress", "resolved", "closed"],
            default: "open" 
        }
    }
};

const uiSchema = {
    subject: {
        "ui:placeholder": "Enter subject",
        "ui:options": { classNames: "boxed-input" }
    },
    questings: {
        
        "ui:widget": "hidden" // 👈 This hides the 'questings' field
    },
    description: {
        "ui:widget": "textarea",
        "ui:placeholder": "Enter description",
        "ui:options": { classNames: "boxed-input" }
    },
    comment: {
       "ui:widget": "hidden" // 👈 This hides the 'questings' field
       
    },
    status: {
        "ui:widget": "select",
        "ui:placeholder": "Select status",
        "ui:options": { classNames: "boxed-input" }
    }
};

const transformErrors = () => [];

const TicketForm = ({ initialData, onSubmit, isUpdateForm = false }) => {
    useEffect(() => {
        const style = document.createElement("style");
        style.innerHTML = `
            .boxed-input input,
            .boxed-input select,
            .boxed-input textarea {
                border: 1px solid #ccc;
                border-radius: 4px;
                padding: 10px;
                background-color: #fff;
                box-shadow: none;
                width: 100%;
                font-size: 14px;
            }
            .boxed-input input:focus,
            .boxed-input select:focus,
            .boxed-input textarea:focus {
                border-color: #000;
                outline: none;
            }
            .boxed-input label {
                font-weight: 500;
                margin-bottom: 6px;
                display: block;
            }
            .errors, .field .errors, .error-detail, .rjsf .alert-danger {
                display: none !important;
            }
            button[type="submit"] {
                background-color:#f0f0f0;
                color: #00c853;
                padding: 10px 20px;
                font-weight: bold;
                border: 1px solid white;
                border-radius: 4px;
                cursor: pointer;
                margin-top: 20px;
                transition: all 0.3s ease;
                font-size: 14px;
            }
            button[type="submit"]:hover {
                background-color: #00c853;
                color: white;
                border-color: #00c853;
            }
        `;
        document.head.appendChild(style);
        return () => document.head.removeChild(style);
    }, []);

    const schema = isUpdateForm ? baseSchema : fullSchema;

    return (
        <div style={{ maxWidth: "600px", marginLeft: "0", paddingLeft: "20px" }}>
            <Form
                schema={schema}
                uiSchema={uiSchema}
                formData={initialData || {}}
                onSubmit={({ formData }) => onSubmit(formData)}
                validator={validator}
                transformErrors={transformErrors}
                showErrorList={false}
                liveValidate
            />
        </div>
    );
};

export default TicketForm;