import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const TicketDB = ({ ticketId, onClose, onDeleteSuccess }) => {
    const [isSubmitting, setSubmitting] = useState(false);
    const [error, setError] = useState('');

    const deleteTicket = () => {
        if (isSubmitting) return;
        setSubmitting(true);
        
        axios.delete(`/tickets/${ticketId}`)
            .then(res => {
                alert("Ticket deleted successfully.");
                if (onDeleteSuccess) onDeleteSuccess();
                onClose();
            })
            .catch(err => {
                setError("Error deleting ticket.");
            })
            .finally(() => {
                setSubmitting(false);
            });
    };

    return (
        <Modal title="Delete Ticket" onClose={onClose}>
            {error && <p style={{ color: 'red' }}>{error}</p>}
            <p>Are you sure you want to delete this ticket?</p>

            <div style={{ display: 'flex', gap: '20px' }}>
                <button 
                    onClick={deleteTicket} 
                    disabled={isSubmitting}
                    style={{
                        backgroundColor: isSubmitting ? '#ccc' : '#ff4d4f',
                        color: 'white',
                        border: 'none',
                        padding: '8px 16px',
                        borderRadius: '4px',
                        cursor: isSubmitting ? 'not-allowed' : 'pointer'
                    }}
                >
                    {isSubmitting ? 'Deleting...' : 'Delete'}
                </button>

                <button 
                    onClick={onClose} 
                    style={{ 
                        backgroundColor: '#f5f5f5',
                        border: '1px solid #d9d9d9',
                        padding: '8px 16px',
                        borderRadius: '4px',
                        cursor: 'pointer'
                    }}
                >
                    Cancel
                </button>
            </div>
        </Modal>
    );
};

export default TicketDB;