import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import TicketForm from './TicketForm';

const AddTicket = ({ onClose, onCreateSuccess }) => {
    const handleSubmit = (formData) => {
        const account_id = localStorage.getItem('account_id');
        const user_id = localStorage.getItem('user_id');

        const payload = {
            ...formData,
            account_id,
            user_id
        };

        axios.post('/ticket/', payload)
            .then(res => {
                alert("Ticket created successfully!");
                if (onCreateSuccess) onCreateSuccess(res.data);
                if (onClose) onClose();
            })
            .catch(err => {
                alert("Error creating ticket.");
                console.error(err);
            });
    };

    return (
     
                <div style={{ maxWidth: '600px', padding: '20px' }}>

            <TicketForm onSubmit={handleSubmit} isUpdateForm={false} />
            </div>
       
    );
};

export default AddTicket;