// src/components/pages/Payments/index.js
import React from 'react';
import PageHeader from '../../common/Header/PageHeader';
import Tabs from '../../common/Tabs';
import Payments from './Payments';
import Invoices from './Invoices';

const Subscriptions = () => {
  const tabsData = [
    { id: 'saas', label: 'Subscriptions' },
    { id: 'payments', label: 'Payments' },
    { id: 'invoices', label: 'Invoices' },
    { id: 'trial', label: 'Trial' },
  ];

  return (
    <div className="payments-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'saas':
              return <Payments initialSearchQuery="" />;
            case 'trial':
              return <Payments initialSearchQuery="" />;
            case 'payments':
            return <Payments initialSearchQuery="" />;
            case 'invoices':
              return <Invoices initialSearchQuery="" />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Subscriptions;
