import React from 'react';
import { usePermission } from '../../../state/usePermission';
import Tabs from '../../common/Tabs';
import SubscriptionsList from './SubscriptionsList';
import AddSubscription from './AddSubscription';

const Subscriptions = ({ featureId = 'subscriptions' }) => {
  const { canCreate } = usePermission(featureId) || { canCreate: true };

  const tabsData = [
    { id: 'list', label: 'Subscriptions' },
    ...(canCreate ? [{ id: 'new', label: 'Add' }] : []),
  ];

  return (
    <div className="subscriptions-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'list':
              return <SubscriptionsList featureId={featureId} />;
            case 'new':
              return <AddSubscription inline />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Subscriptions;
