import React, { useEffect, useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import SubscriptionForm from './SubscriptionForm';

const SubscriptionUpdate = ({ subscriptionId, onClose, onUpdateSuccess }) => {
  const [data, setData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');
  const [statusMessage, setStatusMessage] = useState('');

  useEffect(() => {
    if (!subscriptionId) return;
    axios.get(`crud/subscriptions?skip=0&limit=1&q=&status=&id=${subscriptionId}`)
      .then((res) => {
        const item = Array.isArray(res?.data?.items) ? res.data.items.find(x => x.id === subscriptionId) : null;
        if (item) setData(item);
        setLoading(false);
      })
      .catch(() => {
        axios.get(`crud/subscriptions/${subscriptionId}`)
          .then(r => { setData(r.data); })
          .catch(() => setError('Error fetching subscription data.'))
          .finally(() => setLoading(false));
      });
  }, [subscriptionId]);

  const handleFormDone = (serverData) => {
    setStatusMessage('Subscription updated successfully!');
    onUpdateSuccess && onUpdateSuccess(serverData);
    setTimeout(() => onClose && onClose(), 1200);
  };

  return (
    <Modal title="Edit Subscription" onClose={onClose}>
      {loading ? (
        <div>Loading subscription data...</div>
      ) : (
        <>
          {statusMessage && <p className="success">{statusMessage}</p>}
          {error && <p className="error">{error}</p>}
          {!statusMessage && (
            <SubscriptionForm initialData={data} isEdit onSubmit={handleFormDone} />
          )}
        </>
      )}
    </Modal>
  );
};

export default SubscriptionUpdate;
