import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const SubscriptionDB = ({ subscriptionId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const del = async () => {
    if (isSubmitting) return;
    setSubmitting(true);
    try {
      await axios.delete(`crud/subscriptions/${subscriptionId}`);
      alert('Subscription deleted successfully.');
      onDeleteSuccess && onDeleteSuccess();
      onClose && onClose();
    } catch (e) {
      setError('Error deleting subscription.');
    } finally {
      setSubmitting(false);
    }
  };

  return (
    <Modal title="Delete/Cancel Subscription" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete/cancel this subscription?</p>
      <div style={{ display: 'flex', gap: 8 }}>
        <button onClick={del} className="btn btn-danger" disabled={isSubmitting}>Confirm</button>
        <button onClick={onClose} className="btn">Close</button>
      </div>
    </Modal>
  );
};

export default SubscriptionDB;
