// import React from 'react';
// import CrudModule from '../../common/CRUD/CrudModule'; // Adjust if needed

// const saasPaymentSchema = {
//   title: "",
//   type: "object",
//   properties: {
//     subscription_id: { type: "string", title: "Subscription ID" },
//     amount: { type: "number", title: "Amount" },
//     currency: { type: "string", title: "Currency" },
//     status: {
//       type: "string",
//       title: "Status",
//       enum: ["paid", "unpaid", "overdue", "cancelled"]
//     },
//     invoice_date: { type: "string", format: "date", title: "Invoice Date" },
//     due_date: { type: "string", format: "date", title: "Due Date" },
//     notes: { type: "string", title: "Notes" },
//     account_id: { type: "string", title: "Account ID" },
//     user_id: { type: "string", title: "User ID" }
//   }
// };

// const saasPaymentUiSchema = {
//   account_id: {
//     "ui:widget": "select",
//     "ui:placeholder": "Search account...",
//     "ui:options": {
//       asyncEnum: true,
//       fetchUrlKey: "dynamic_accounts",
//       labelField: "name",
//       valueField: "account_id",
//       debounce: 300
//     }
//   }
// };

// const SaaSPayments = ({ isGlobalAccess, accountId }) => {
//   const dynamicFetchUrls = {
//     dynamic_accounts: isGlobalAccess
//       ? "/accounts/"
//       : `/accounts/?account_id=${accountId}`
//   };

//   return (
//     <CrudModule
//       collectionName="subscriptions"
//       title="SaaS Payments"
//       description="View all payment transactions for subscriptions."
//       headerMapping={{
//         "Subscription ID": { key: "subscription_type_id", clickable: true ,sortable: true},
//         "Amount": { key: "total_cost", clickable: false ,sortable: false},
//        // "Currency": { key: "currency", clickable: false ,sortable: false},
//        // "Agents Count": { key: "active_agents_count", clickable: false ,sortable: false},

        
//         "Status": { key: "status", clickable: false ,sortable: false},
//         "Invoice Date": { key: "renew_start_date", clickable: false ,sortable: false},
//         "Due Date": { key: "renew_end_date", clickable: false ,sortable: false},
//         "Account ID": { key: "account_id", clickable: true ,sortable: true},
//         "User ID": { key: "user_id", clickable: true ,sortable: true},
//         "Created Date": { key: "start_date", clickable: false ,sortable: false},
//       }}
//       dataKey="items"
//       identifierKey="saaspayment_id"
//       schema={saasPaymentSchema}
//       uiSchema={saasPaymentUiSchema}
//       fetchUrl="/crud/subscriptions/"
//       dynamicFetchUrls={dynamicFetchUrls}
//       searchFields={[
//         { name: 'q', type: 'text', placeholder: 'Search payments...' },
//         {
//           name: 'status',
//           type: 'dropdown',
//           placeholder: 'Filter by status',
//           options: [
//             { label: 'All', value: '' },
//             { label: 'Paid', value: 'paid' },
//             { label: 'Unpaid', value: 'unpaid' },
//             { label: 'Overdue', value: 'overdue' },
//             { label: 'Cancelled', value: 'cancelled' }
//           ]
//         }
//       ]}
//       rowsPerPage={10}
//       // 👇 Disable all CRUD actions
//       actionFormats={[]} 
//       disableCreate={true} // If CrudModule supports this flag
//     />
//   );
// };

// export default SaaSPayments;


import React from 'react';
import CrudModule from '../../common/CRUD/CrudModule';

const saasPaymentSchema = {
  title: "",
  type: "object",
  properties: {
    subscription_id: { type: "string", title: "Subscription ID" },
    amount: { type: "number", title: "Amount" },
    currency: { type: "string", title: "Currency" },
    status: {
      type: "string",
      title: "Status",
      enum: ["paid", "unpaid", "overdue", "cancelled"]
    },
    invoice_date: { type: "string", format: "date", title: "Invoice Date" },
    due_date: { type: "string", format: "date", title: "Due Date" },
    notes: { type: "string", title: "Notes" },
    account_id: { type: "string", title: "Account ID" },
    user_id: { type: "string", title: "User ID" }
  }
};

const saasPaymentUiSchema = {
  account_id: {
    "ui:widget": "select",
    "ui:placeholder": "Search account...",
    "ui:options": {
      asyncEnum: true,
      fetchUrlKey: "dynamic_accounts",
      labelField: "name",
      valueField: "account_id",
      debounce: 300
    }
  }
};

const SaaSPayments = ({ isGlobalAccess, accountId }) => {
  const dynamicFetchUrls = {
    dynamic_accounts: isGlobalAccess
      ? "/accounts/"
      : `/accounts/?account_id=${accountId}`
  };

  return (
    <CrudModule
      collectionName="subscriptions"
      title="SaaS Payments"
      description="View all payment transactions for subscriptions."
      headerMapping={{
        "Subscription ID": { key: "subscription_type_id", clickable: true, sortable: true },
        "Amount": { key: "total_cost", clickable: false, sortable: false },
        "Status": { key: "status", clickable: false, sortable: false },
        "Invoice Date": { key: "renew_start_date", clickable: false, sortable: false },
        "Due Date": { key: "renew_end_date", clickable: false, sortable: false },
        "Account ID": { key: "account_id", clickable: true, sortable: true },
        "User ID": { key: "user_id", clickable: true, sortable: true },
        "Created Date": { key: "start_date", clickable: false, sortable: false },
      }}
      dataKey="items"
      identifierKey="id"
      schema={saasPaymentSchema}
      uiSchema={saasPaymentUiSchema}
      fetchUrl="/crud/subscriptions/"
      dynamicFetchUrls={dynamicFetchUrls}
      searchFields={[
        { name: 'q', type: 'text', placeholder: 'Search payments...' },
        {
          name: 'status',
          type: 'dropdown',
          placeholder: 'Filter by status',
          options: [
            { label: 'All', value: '' },
            { label: 'Paid', value: 'paid' },
            { label: 'Unpaid', value: 'unpaid' },
            { label: 'Overdue', value: 'overdue' },
            { label: 'Cancelled', value: 'cancelled' }
          ]
        }
      ]}
      rowsPerPage={10}
      actionFormats={[
        { label: 'view', modal: true, url: '/saaspayment/view/{id}' },
        { label: 'edit', modal: true, url: '/saaspayment/update/{id}' },
        { label: 'delete', modal: true, url: '/saaspayment/delete/{id}' }
      ]}
    />
  );
};

export default SaaSPayments;