import React from 'react';
import SubscriptionForm from './SubscriptionForm';

export default function AddSubscription({ onClose, onCreated, inline = false }) {
  const handleSuccess = (data) => {
    onCreated && onCreated(data);
    onClose && onClose();
  };

  const content = <SubscriptionForm onSubmit={handleSuccess} />;

  return inline ? <div style={{ padding: 8 }}>{content}</div> : content;
}
