// src/components/adminpages/Settings/ReferralSettingsPage.js
import React, { useEffect, useState } from 'react';

export default function ReferralSettingsPage({ data = {}, onSave }) {
  const [f, setF] = useState({
    enable: true, type: 'percentage', value: 10, cookie_days: 30,
    first_only: true, recurring: false, recurring_cycles: 0,
    max_per_order: 0, payout_schedule: 'monthly', min_payout: 500,
    payout_methods: 'bank,stripe_transfer', code_prefix: 'SKY',
    auto_approve: false, kyc: true, tnc_url: '', notify: true
  });

  useEffect(() => { if (data.referral) setF(s => ({ ...s, ...data.referral })); }, [data]);
  const upd = k => e => setF(s => ({ ...s, [k]: e.target.type === 'checkbox' ? e.target.checked : e.target.value }));
  const save = e => { e.preventDefault(); onSave && onSave('referral', {
    ...f,
    value:+f.value||0, cookie_days:+f.cookie_days||0, recurring_cycles:+f.recurring_cycles||0,
    max_per_order:+f.max_per_order||0, min_payout:+f.min_payout||0,
    payout_methods:String(f.payout_methods).split(',').map(x=>x.trim()).filter(Boolean)
  });};

  const row = { display:'flex', gap:16, flexWrap:'wrap', margin:'8px 0' };
  const col = { flex:'1 1 260px' };
  const label = { display:'block', fontSize:12, color:'#666', marginBottom:4 };
  const input = { width:'100%', padding:'10px 12px', border:'1px solid #dfe5ea', borderRadius:8 };

  return (
    <form onSubmit={save}>
      <h3 style={{display:'flex',alignItems:'center',gap:8}}>
        <span className="material-symbols-outlined" style={{color:'#2e7d32'}}>diversity_3</span>
        Referral / Partners Commission
      </h3>

      <div style={{...row, alignItems:'center'}}>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={f.enable} onChange={upd('enable')}/> Enable referrals
        </label>
      </div>

      <div style={row}>
        <div style={col}>
          <label style={label}>Commission Type</label>
          <select style={input} value={f.type} onChange={upd('type')}>
            <option value="percentage">percentage</option>
            <option value="fixed">fixed</option>
          </select>
        </div>
        <div style={col}>
          <label style={label}>{f.type==='percentage'?'Commission %':'Commission amount'}</label>
          <input style={input} type="number" value={f.value} onChange={upd('value')}/>
        </div>
      </div>

      <div style={row}>
        <div style={col}>
          <label style={label}>Cookie window (days)</label>
          <input style={input} type="number" value={f.cookie_days} onChange={upd('cookie_days')}/>
        </div>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={f.first_only} onChange={upd('first_only')}/> First purchase only
        </label>
      </div>

      <div style={row}>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={f.recurring} onChange={upd('recurring')}/> Recurring commission
        </label>
        <div style={col}>
          <label style={label}>Recurring max cycles</label>
          <input style={input} type="number" value={f.recurring_cycles} onChange={upd('recurring_cycles')}/>
        </div>
      </div>

      <div style={row}>
        <div style={col}>
          <label style={label}>Max commission / order</label>
          <input style={input} type="number" value={f.max_per_order} onChange={upd('max_per_order')}/>
        </div>
        <div style={col}>
          <label style={label}>Payout schedule</label>
          <select style={input} value={f.payout_schedule} onChange={upd('payout_schedule')}>
            <option value="instant">instant</option><option value="weekly">weekly</option>
            <option value="monthly">monthly</option><option value="net-30">net-30</option>
          </select>
        </div>
      </div>

      <div style={row}>
        <div style={col}>
          <label style={label}>Minimum payout threshold</label>
          <input style={input} type="number" value={f.min_payout} onChange={upd('min_payout')}/>
        </div>
        <div style={col}>
          <label style={label}>Payout methods (comma separated)</label>
          <input style={input} value={f.payout_methods} onChange={upd('payout_methods')}/>
        </div>
      </div>

      <div style={row}>
        <div style={col}>
          <label style={label}>Partner code prefix</label>
          <input style={input} value={f.code_prefix} onChange={upd('code_prefix')}/>
        </div>
      </div>

      <div style={row}>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={f.auto_approve} onChange={upd('auto_approve')}/> Auto-approve partners
        </label>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={f.kyc} onChange={upd('kyc')}/> KYC required
        </label>
      </div>

      <div style={row}>
        <div style={{...col, minWidth: '100%'}}>
          <label style={label}>Terms & Conditions URL</label>
          <input style={input} type="url" value={f.tnc_url} onChange={upd('tnc_url')}/>
        </div>
      </div>

      <div style={row}>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={f.notify} onChange={upd('notify')}/> Notify on new signup
        </label>
      </div>

      <button type="submit" style={{background:'#2e7d32',color:'#fff',border:0,padding:'10px 16px',borderRadius:8,fontWeight:600}}>
        Save Changes
      </button>
    </form>
  );
}
