// src/components/adminpages/Settings/PaymentSettingsPage.js
import React, { useEffect, useState } from 'react';

export default function PaymentSettingsPage({ data = {}, onSave }) {
  const [company, setC] = useState({ name:'', taxid:'', currency:'NOK', addr1:'', addr2:'', city:'', postal:'', region:'', country:'NO', invoice_prefix:'SB-', vat:25, invoice_footer:'', pdf_invoices:true });
  const [stripe, setS] = useState({ enable:true, mode:'test', pk:'', sk:'', whsec:'', methods:'card, link', capture:'automatic', descriptor:'', refunds:true, refund_window:14, min_charge:0, max_charge:99999, sca:true, webhook_url:'https://yourdomain.com/api/stripe/webhook' });
  const [bank, setB] = useState({ name:'', iban:'', bic:'', bank:'', addr:'', ref_tpl:'Invoice {number}', domestic:'', terms:'net14', late_fee:0, reminders:'T-3, Due, T+7, T+14' });

  useEffect(()=>{ if(data.payment?.company) setC(s=>({...s,...data.payment.company}));
                  if(data.payment?.stripe) setS(s=>({...s,...data.payment.stripe}));
                  if(data.payment?.bank) setB(s=>({...s,...data.payment.bank})); }, [data]);

  const row = { display:'flex', gap:16, flexWrap:'wrap', margin:'8px 0' };
  const col = { flex:'1 1 260px' };
  const label = { display:'block', fontSize:12, color:'#666', marginBottom:4 };
  const input = { width:'100%', padding:'10px 12px', border:'1px solid #dfe5ea', borderRadius:8 };
  const save = e => { e.preventDefault(); onSave && onSave('payment', { company, stripe, bank }); };

  return (
    <form onSubmit={save}>
    
      <h4 style={{display:'flex',alignItems:'center',gap:8}}>
        <span className="material-symbols-outlined" style={{color:'#2e7d32'}}>grid_on</span> Company Profile
      </h4>
      <div style={row}>
        <div style={col}><label style={label}>Company name</label><input style={input} value={company.name} onChange={e=>setC(s=>({...s,name:e.target.value}))}/></div>
        <div style={col}><label style={label}>Org/Tax ID</label><input style={input} value={company.taxid} onChange={e=>setC(s=>({...s,taxid:e.target.value}))}/></div>
        <div style={col}>
          <label style={label}>Currency</label>
          <select style={input} value={company.currency} onChange={e=>setC(s=>({...s,currency:e.target.value}))}><option>NOK</option><option>EUR</option><option>USD</option></select>
        </div>
      </div>
      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Address line 1</label><input style={input} value={company.addr1} onChange={e=>setC(s=>({...s,addr1:e.target.value}))}/></div></div>
      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Address line 2</label><input style={input} value={company.addr2} onChange={e=>setC(s=>({...s,addr2:e.target.value}))}/></div></div>
      <div style={row}>
        <div style={col}><label style={label}>City</label><input style={input} value={company.city} onChange={e=>setC(s=>({...s,city:e.target.value}))}/></div>
        <div style={col}><label style={label}>Postal code</label><input style={input} value={company.postal} onChange={e=>setC(s=>({...s,postal:e.target.value}))}/></div>
        <div style={col}><label style={label}>State/Region</label><input style={input} value={company.region} onChange={e=>setC(s=>({...s,region:e.target.value}))}/></div>
        <div style={col}><label style={label}>Country</label><input style={input} value={company.country} onChange={e=>setC(s=>({...s,country:e.target.value}))}/></div>
      </div>
      <div style={row}>
        <div style={col}><label style={label}>Invoice prefix</label><input style={input} value={company.invoice_prefix} onChange={e=>setC(s=>({...s,invoice_prefix:e.target.value}))}/></div>
        <div style={col}><label style={label}>VAT rate (%)</label><input style={input} type="number" value={company.vat} onChange={e=>setC(s=>({...s,vat:e.target.value}))}/></div>
      </div>
      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Invoice footer</label><textarea style={{...input, minHeight:80}} value={company.invoice_footer} onChange={e=>setC(s=>({...s,invoice_footer:e.target.value}))}/></div></div>
      <div style={row}><label style={{display:'flex',alignItems:'center',gap:8}}>
        <input type="checkbox" checked={!!company.pdf_invoices} onChange={e=>setC(s=>({...s,pdf_invoices:e.target.checked}))}/> Enable PDF invoices
      </label></div>

      <h4 style={{display:'flex',alignItems:'center',gap:8, marginTop:12}}>
        <span className="material-symbols-outlined" style={{color:'#2e7d32'}}>payments</span> Stripe
      </h4>
      <div style={row}>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={stripe.enable} onChange={e=>setS(s=>({...s,enable:e.target.checked}))}/> Enable Stripe
        </label>
        <div style={col}><label style={label}>Mode</label>
          <select style={input} value={stripe.mode} onChange={e=>setS(s=>({...s,mode:e.target.value}))}><option value="test">test</option><option value="live">live</option></select>
        </div>
      </div>
      <div style={row}>
        <div style={col}><label style={label}>Publishable key</label><input style={input} value={stripe.pk} onChange={e=>setS(s=>({...s,pk:e.target.value}))}/></div>
        <div style={col}><label style={label}>Secret key</label><input style={input} type="password" value={stripe.sk} onChange={e=>setS(s=>({...s,sk:e.target.value}))}/></div>
        <div style={col}><label style={label}>Webhook signing secret</label><input style={input} type="password" value={stripe.whsec} onChange={e=>setS(s=>({...s,whsec:e.target.value}))}/></div>
      </div>
      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Payment methods</label><input style={input} value={stripe.methods} onChange={e=>setS(s=>({...s,methods:e.target.value}))}/></div></div>
      <div style={row}>
        <div style={col}><label style={label}>Capture behavior</label>
          <select style={input} value={stripe.capture} onChange={e=>setS(s=>({...s,capture:e.target.value}))}><option value="automatic">automatic</option><option value="manual">manual</option></select>
        </div>
        <div style={col}><label style={label}>Statement descriptor</label><input style={input} value={stripe.descriptor} onChange={e=>setS(s=>({...s,descriptor:e.target.value}))}/></div>
      </div>
      <div style={row}>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={stripe.refunds} onChange={e=>setS(s=>({...s,refunds:e.target.checked}))}/> Allow refunds
        </label>
        <div style={col}><label style={label}>Refund window (days)</label><input style={input} type="number" value={stripe.refund_window} onChange={e=>setS(s=>({...s,refund_window:e.target.value}))}/></div>
        <div style={col}><label style={label}>Min charge</label><input style={input} type="number" value={stripe.min_charge} onChange={e=>setS(s=>({...s,min_charge:e.target.value}))}/></div>
        <div style={col}><label style={label}>Max charge</label><input style={input} type="number" value={stripe.max_charge} onChange={e=>setS(s=>({...s,max_charge:e.target.value}))}/></div>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={stripe.sca} onChange={e=>setS(s=>({...s,sca:e.target.checked}))}/> SCA enabled
        </label>
      </div>
      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Webhook URL</label><input style={input} readOnly value={stripe.webhook_url}/></div></div>

      <h4 style={{display:'flex',alignItems:'center',gap:8, marginTop:12}}>
        <span className="material-symbols-outlined" style={{color:'#2e7d32'}}>account_balance</span> Bank Account
      </h4>
      <div style={row}>
        <div style={col}><label style={label}>Beneficiary name</label><input style={input} value={bank.name} onChange={e=>setB(s=>({...s,name:e.target.value}))}/></div>
        <div style={col}><label style={label}>IBAN</label><input style={input} value={bank.iban} onChange={e=>setB(s=>({...s,iban:e.target.value}))}/></div>
        <div style={col}><label style={label}>BIC/SWIFT</label><input style={input} value={bank.bic} onChange={e=>setB(s=>({...s,bic:e.target.value}))}/></div>
        <div style={col}><label style={label}>Bank</label><input style={input} value={bank.bank} onChange={e=>setB(s=>({...s,bank:e.target.value}))}/></div>
      </div>
      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Bank address</label><input style={input} value={bank.addr} onChange={e=>setB(s=>({...s,addr:e.target.value}))}/></div></div>
      <div style={row}>
        <div style={col}><label style={label}>Reference message template</label><input style={input} value={bank.ref_tpl} onChange={e=>setB(s=>({...s,ref_tpl:e.target.value}))}/></div>
        <div style={col}>
          <label style={label}>Payment terms</label>
          <select style={input} value={bank.terms} onChange={e=>setB(s=>({...s,terms:e.target.value}))}>
            <option value="due_on_receipt">Due on receipt</option><option value="net7">Net 7</option>
            <option value="net14">Net 14</option><option value="net30">Net 30</option>
          </select>
        </div>
        <div style={col}><label style={label}>Late fee (%)</label><input style={input} type="number" value={bank.late_fee} onChange={e=>setB(s=>({...s,late_fee:e.target.value}))}/></div>
        <div style={col}><label style={label}>Domestic account no.</label><input style={input} value={bank.domestic} onChange={e=>setB(s=>({...s,domestic:e.target.value}))}/></div>
      </div>
      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Reminder schedule</label><input style={input} value={bank.reminders} onChange={e=>setB(s=>({...s,reminders:e.target.value}))}/></div></div>

      <button type="submit" style={{background:'#2e7d32',color:'#fff',border:0,padding:'10px 16px',borderRadius:8,fontWeight:600}}>Save Changes</button>
    </form>
  );
}
