// src/components/adminpages/Settings/CommunicationSettingsPage.js
import React, { useEffect, useState } from 'react';

export default function CommunicationSettingsPage({ data = {}, onSave }) {
  // Your file currently shows "Business Profile" here — I’ll keep that.
  const [f, setF] = useState({
    business_name:'', business_email:'', business_phone:'', business_type:'',
    address:'', city:'', region:'', postal:'', country:'NO', website:''
  });

  useEffect(()=>{ if(data.account) setF(s=>({...s,...data.account})); }, [data]);

  const upd = k => e => setF(s=>({...s, [k]: e.target.value}));
  const save = e => { e.preventDefault(); onSave && onSave('account', f); };

  const row = { display:'flex', gap:16, flexWrap:'wrap', margin:'8px 0' };
  const col = { flex:'1 1 260px' };
  const label = { display:'block', fontSize:12, color:'#666', marginBottom:4 };
  const input = { width:'100%', padding:'10px 12px', border:'1px solid #dfe5ea', borderRadius:8 };

  return (
    <form onSubmit={save}>
     
      <h4 style={{display:'flex',alignItems:'center',gap:8}}>
        <span className="material-symbols-outlined" style={{color:'#2e7d32'}}>diversity_3</span> Business Profile
      </h4>

      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Business Name</label><input style={input} value={f.business_name} onChange={upd('business_name')}/></div></div>
      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Business Email</label><input style={input} value={f.business_email} onChange={upd('business_email')}/></div></div>

      <div style={row}>
        <div style={col}><label style={label}>Business Phone</label><input style={input} value={f.business_phone} onChange={upd('business_phone')}/></div>
        <div style={col}><label style={label}>Business Type</label><input style={input} value={f.business_type} onChange={upd('business_type')}/></div>
      </div>

      <div style={row}><div style={{...col,minWidth:'100%'}}><label style={label}>Business Address</label><input style={input} value={f.address} onChange={upd('address')}/></div></div>
      <div style={row}>
        <div style={col}><label style={label}>City</label><input style={input} value={f.city} onChange={upd('city')}/></div>
        <div style={col}><label style={label}>Region</label><input style={input} value={f.region} onChange={upd('region')}/></div>
        <div style={col}><label style={label}>Postal Code</label><input style={input} value={f.postal} onChange={upd('postal')}/></div>
      </div>
      <div style={row}>
        <div style={col}><label style={label}>Country</label><input style={input} value={f.country} onChange={upd('country')}/></div>
        <div style={col}><label style={label}>Website</label><input style={input} value={f.website} onChange={upd('website')}/></div>
      </div>

      <button type="submit" style={{background:'#2e7d32',color:'#fff',border:0,padding:'10px 16px',borderRadius:8,fontWeight:600}}>Save Changes</button>
    </form>
  );
}
