// src/components/adminpages/Settings/ApplicationSettingsPage.js
import React, { useEffect, useState } from 'react';

export default function ApplicationSettingsPage({ data = {}, onSave }) {
  const [gmaps, setG] = useState({ enable:true, api_key:'', region:'NO', lang:'nb', lat:59.413, lng:5.297, zoom:10, autocomplete:'address, establishment', unit:'km' });
  const [twilio, setT] = useState({ enable:false, sid:'', token:'', msg_sid:'', from:'', whatsapp:'', rate:60, webhook:'', otp_tpl:'Your code is {code}, valid for {ttl} minutes.' });

  useEffect(() => {
    if (data.application?.gmaps) setG(s => ({ ...s, ...data.application.gmaps }));
    if (data.application?.twilio) setT(s => ({ ...s, ...data.application.twilio }));
  }, [data]);

  const row = { display:'flex', gap:16, flexWrap:'wrap', margin:'8px 0' };
  const col = { flex:'1 1 260px' };
  const label = { display:'block', fontSize:12, color:'#666', marginBottom:4 };
  const input = { width:'100%', padding:'10px 12px', border:'1px solid #dfe5ea', borderRadius:8 };

  const save = e => { e.preventDefault(); onSave && onSave('application', { gmaps, twilio }); };

  return (
    <form onSubmit={save}>
      
      <h4 style={{display:'flex',alignItems:'center',gap:8, marginTop:8}}>
        <span className="material-symbols-outlined" style={{color:'#2e7d32'}}>map</span> Google Maps
      </h4>

      <div style={row}>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={gmaps.enable} onChange={e=>setG(s=>({...s,enable:e.target.checked}))}/> Enable Maps
        </label>
      </div>

      <div style={row}>
        <div style={{...col, minWidth:'100%'}}>
          <label style={label}>API Key</label>
          <input style={input} type="password" value={gmaps.api_key} onChange={e=>setG(s=>({...s,api_key:e.target.value}))}/>
        </div>
      </div>

      <div style={row}>
        <div style={col}><label style={label}>Region</label><input style={input} value={gmaps.region} onChange={e=>setG(s=>({...s,region:e.target.value}))}/></div>
        <div style={col}><label style={label}>Language</label><input style={input} value={gmaps.lang} onChange={e=>setG(s=>({...s,lang:e.target.value}))}/></div>
        <div style={col}><label style={label}>Lat</label><input style={input} type="number" value={gmaps.lat} onChange={e=>setG(s=>({...s,lat:e.target.value}))}/></div>
        <div style={col}><label style={label}>Lng</label><input style={input} type="number" value={gmaps.lng} onChange={e=>setG(s=>({...s,lng:e.target.value}))}/></div>
        <div style={col}><label style={label}>Zoom</label><input style={input} type="number" value={gmaps.zoom} onChange={e=>setG(s=>({...s,zoom:e.target.value}))}/></div>
      </div>

      <div style={row}>
        <div style={col}><label style={label}>Autocomplete types</label><input style={input} value={gmaps.autocomplete} onChange={e=>setG(s=>({...s,autocomplete:e.target.value}))}/></div>
        <div style={col}>
          <label style={label}>Distance unit</label>
          <select style={input} value={gmaps.unit} onChange={e=>setG(s=>({...s,unit:e.target.value}))}>
            <option value="km">km</option><option value="mi">mi</option>
          </select>
        </div>
      </div>

      <h4 style={{display:'flex',alignItems:'center',gap:8, marginTop:12}}>
        <span className="material-symbols-outlined" style={{color:'#2e7d32'}}>sms</span> Twilio
      </h4>

      <div style={row}>
        <label style={{display:'flex',alignItems:'center',gap:8}}>
          <input type="checkbox" checked={twilio.enable} onChange={e=>setT(s=>({...s,enable:e.target.checked}))}/> Enable Twilio
        </label>
      </div>

      <div style={row}>
        <div style={col}><label style={label}>Account SID</label><input style={input} type="password" value={twilio.sid} onChange={e=>setT(s=>({...s,sid:e.target.value}))}/></div>
        <div style={col}><label style={label}>Auth Token</label><input style={input} type="password" value={twilio.token} onChange={e=>setT(s=>({...s,token:e.target.value}))}/></div>
      </div>

      <div style={row}>
        <div style={col}><label style={label}>Messaging Service SID</label><input style={input} value={twilio.msg_sid} onChange={e=>setT(s=>({...s,msg_sid:e.target.value}))}/></div>
        <div style={col}><label style={label}>From number (E.164)</label><input style={input} value={twilio.from} onChange={e=>setT(s=>({...s,from:e.target.value}))}/></div>
        <div style={col}><label style={label}>WhatsApp sender</label><input style={input} value={twilio.whatsapp} onChange={e=>setT(s=>({...s,whatsapp:e.target.value}))}/></div>
        <div style={col}><label style={label}>Rate (msg/min)</label><input style={input} type="number" value={twilio.rate} onChange={e=>setT(s=>({...s,rate:e.target.value}))}/></div>
      </div>

      <div style={row}>
        <div style={{...col, minWidth:'100%'}}><label style={label}>Delivery webhook URL</label><input style={input} value={twilio.webhook} onChange={e=>setT(s=>({...s,webhook:e.target.value}))}/></div>
        <div style={{...col, minWidth:'100%'}}><label style={label}>OTP template</label><input style={input} value={twilio.otp_tpl} onChange={e=>setT(s=>({...s,otp_tpl:e.target.value}))}/></div>
      </div>

      <button type="submit" style={{background:'#2e7d32',color:'#fff',border:0,padding:'10px 16px',borderRadius:8,fontWeight:600}}>Save Changes</button>
    </form>
  );
}
